/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.model.ModelContainer;
import org.eclipse.team.examples.model.ModelObject;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelObjectElementFile;
import org.eclipse.team.examples.model.ModelProject;
import org.eclipse.team.examples.model.ModelWorkspace;
import org.eclipse.team.examples.model.ui.ModelNavigatorContentProvider;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.SynchronizationResourceMappingContext;
import org.eclipse.team.ui.mapping.SynchronizationContentProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class ModelSyncContentProvider
extends SynchronizationContentProvider
implements IPipelinedTreeContentProvider {
    private ModelNavigatorContentProvider delegate;

    public void init(ICommonContentExtensionSite site) {
        super.init(site);
        this.delegate = new ModelNavigatorContentProvider(this.getContext() != null);
        this.delegate.init(site);
    }

    public void dispose() {
        super.dispose();
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    protected ITreeContentProvider getDelegateContentProvider() {
        return this.delegate;
    }

    protected String getModelProviderId() {
        return "org.eclipse.team.examples.filesystem.modelProvider";
    }

    protected Object getModelRoot() {
        return ModelWorkspace.getRoot();
    }

    protected ResourceTraversal[] getTraversals(ISynchronizationContext context, Object object) {
        if (object instanceof ModelObject) {
            ModelObject mo = (ModelObject)((Object)object);
            ResourceMapping mapping = (ResourceMapping)mo.getAdapter(ResourceMapping.class);
            SynchronizationResourceMappingContext rmc = new SynchronizationResourceMappingContext(context);
            try {
                return mapping.getTraversals((ResourceMappingContext)rmc, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                FileSystemPlugin.log(e);
            }
        }
        return new ResourceTraversal[0];
    }

    protected Object[] getChildrenInContext(ISynchronizationContext context, Object parent, Object[] children) {
        ModelObject o;
        IResource resource;
        IDiff diff;
        int n;
        int n2;
        IDiff[] iDiffArray;
        IDiff[] diffs;
        HashSet<Object> allChildren = new HashSet<Object>();
        allChildren.addAll(Arrays.asList(super.getChildrenInContext(context, parent, children)));
        if (parent instanceof ModelContainer) {
            ModelContainer mc = (ModelContainer)((Object)parent);
            iDiffArray = diffs = context.getDiffTree().getDiffs(mc.getResource(), 1);
            n2 = diffs.length;
            n = 0;
            while (n < n2) {
                diff = iDiffArray[n];
                resource = ResourceDiffTree.getResourceFor((IDiff)diff);
                if (!resource.exists() && ModelObjectDefinitionFile.isModFile(resource) && (o = ModelObject.create(resource)) != null) {
                    allChildren.add((Object)o);
                }
                ++n;
            }
        }
        if (parent instanceof ModelObjectDefinitionFile) {
            ResourceTraversal[] traversals = this.getTraversals(context, parent);
            iDiffArray = diffs = context.getDiffTree().getDiffs(traversals);
            n2 = diffs.length;
            n = 0;
            while (n < n2) {
                diff = iDiffArray[n];
                resource = ResourceDiffTree.getResourceFor((IDiff)diff);
                if (!resource.exists() && ModelObjectElementFile.isMoeFile(resource) && (o = new ModelObjectElementFile((ModelObjectDefinitionFile)((Object)parent), (IFile)resource)) != null) {
                    allChildren.add((Object)o);
                }
                ++n;
            }
        }
        return allChildren.toArray(new Object[allChildren.size()]);
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
        if (anInput instanceof ISynchronizationContext) {
            ArrayList<ModelObject> newProjects = new ArrayList<ModelObject>();
            Iterator iter = theCurrentElements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IProject)) continue;
                IProject project = (IProject)element;
                try {
                    if (!ModelProject.isModProject(project)) continue;
                    iter.remove();
                    newProjects.add(ModelObject.create((IResource)project));
                }
                catch (CoreException e) {
                    FileSystemPlugin.log(e);
                }
            }
            theCurrentElements.addAll(newProjects);
        } else if (anInput instanceof ISynchronizationScope) {
            theCurrentElements.add(this.getModelProvider());
        }
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        return aSuggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        if (anAddModification.getParent() instanceof ISynchronizationContext) {
            Iterator iter = anAddModification.getChildren().iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof IProject)) continue;
                IProject project = (IProject)element;
                try {
                    if (!ModelProject.isModProject(project)) continue;
                    iter.remove();
                }
                catch (CoreException e) {
                    FileSystemPlugin.log(e);
                }
            }
        }
        return null;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        return false;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return aRemoveModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return false;
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        Utils.syncExec(() -> this.handleChange(event), (StructuredViewer)((StructuredViewer)this.getViewer()));
    }

    void handleChange(IDiffChangeEvent event) {
        Set existingProjects = this.getVisibleModelProjects();
        IProject[] changedProjects = this.getChangedModelProjects(event);
        ArrayList<ModelObject> refreshes = new ArrayList<ModelObject>(changedProjects.length);
        ArrayList<ModelObject> additions = new ArrayList<ModelObject>(changedProjects.length);
        ArrayList<ModelObject> removals = new ArrayList<ModelObject>(changedProjects.length);
        IProject[] iProjectArray = changedProjects;
        int n = changedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.hasVisibleChanges(event.getTree(), project)) {
                if (existingProjects.contains(project)) {
                    refreshes.add(ModelObject.create((IResource)project));
                } else {
                    additions.add(ModelObject.create((IResource)project));
                }
            } else if (existingProjects.contains(project)) {
                removals.add(ModelObject.create((IResource)project));
            }
            ++n2;
        }
        if (!(removals.isEmpty() && additions.isEmpty() && refreshes.isEmpty())) {
            TreeViewer viewer = (TreeViewer)this.getViewer();
            Tree tree = viewer.getTree();
            try {
                tree.setRedraw(false);
                if (!additions.isEmpty()) {
                    viewer.add(viewer.getInput(), additions.toArray());
                }
                if (!removals.isEmpty()) {
                    viewer.remove(viewer.getInput(), removals.toArray());
                }
                if (!refreshes.isEmpty()) {
                    for (Object e : refreshes) {
                        viewer.refresh(e);
                    }
                }
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    private boolean hasVisibleChanges(IDiffTree tree, IProject project) {
        return tree.hasMatchingDiffs(project.getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff diff) {
                return ModelSyncContentProvider.this.isVisible(diff);
            }
        });
    }

    private IProject[] getChangedModelProjects(IDiffChangeEvent event) {
        IPath[] removals;
        IDiff[] additions;
        IDiff[] changes;
        HashSet<IProject> result = new HashSet<IProject>();
        IDiff[] iDiffArray = changes = event.getChanges();
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff diff = iDiffArray[n2];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null && this.isModProject(resource.getProject())) {
                result.add(resource.getProject());
            }
            ++n2;
        }
        IDiff[] iDiffArray2 = additions = event.getAdditions();
        int n3 = additions.length;
        n = 0;
        while (n < n3) {
            IDiff diff = iDiffArray2[n];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null && this.isModProject(resource.getProject())) {
                result.add(resource.getProject());
            }
            ++n;
        }
        IPath[] iPathArray = removals = event.getRemovals();
        int n4 = removals.length;
        n3 = 0;
        while (n3 < n4) {
            IProject project;
            IPath path = iPathArray[n3];
            if (path.segmentCount() > 0 && this.isModProject(project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)))) {
                result.add(project);
            }
            ++n3;
        }
        return result.toArray(new IProject[result.size()]);
    }

    private boolean isModProject(IProject project) {
        try {
            return ModelProject.isModProject(project);
        }
        catch (CoreException e) {
            FileSystemPlugin.log(e);
            return false;
        }
    }

    private Set getVisibleModelProjects() {
        TreeViewer viewer = (TreeViewer)this.getViewer();
        Tree tree = viewer.getTree();
        TreeItem[] children = tree.getItems();
        HashSet<ModelProject> result = new HashSet<ModelProject>();
        TreeItem[] treeItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem control = treeItemArray[n2];
            Object data = control.getData();
            if (data instanceof ModelProject) {
                result.add(((ModelProject)((Object)data)).getProject());
            }
            ++n2;
        }
        return result;
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
        if (this.getContext() == null) {
            return;
        }
        HashSet<ModelObject> updates = new HashSet<ModelObject>();
        boolean refresh = false;
        IPath[] iPathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            IDiff diff = tree.getDiff(path);
            if (diff != null) {
                IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
                ModelObject object = ModelObject.create(resource);
                if (object != null) {
                    updates.add(object);
                } else {
                    refresh = true;
                }
            }
            ++n2;
        }
        if (!updates.isEmpty() || refresh) {
            boolean refreshAll = refresh;
            StructuredViewer viewer = (StructuredViewer)this.getViewer();
            Utils.syncExec(() -> {
                if (refreshAll) {
                    viewer.refresh(true);
                } else {
                    viewer.update((Object[])updates.toArray(new ModelObject[updates.size()]), null);
                }
            }, (StructuredViewer)viewer);
        }
    }
}

