/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.model.ui.mapping;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.model.ModelObjectDefinitionFile;
import org.eclipse.team.examples.model.ModelObjectElementFile;
import org.eclipse.team.examples.model.ModelResource;
import org.eclipse.team.examples.model.ui.ModelNavigatorLabelProvider;
import org.eclipse.team.ui.mapping.SynchronizationLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class ModelSyncLabelProvider
extends SynchronizationLabelProvider {
    private ModelNavigatorLabelProvider delegate;

    public void init(ICommonContentExtensionSite site) {
        super.init(site);
        this.delegate = new ModelNavigatorLabelProvider();
        this.delegate.init(site);
    }

    public void dispose() {
        super.dispose();
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    protected ILabelProvider getDelegateLabelProvider() {
        return this.delegate;
    }

    protected IDiff getDiff(Object element) {
        if (element instanceof ModelResource) {
            ModelResource mr = (ModelResource)((Object)element);
            return this.getContext().getDiffTree().getDiff(mr.getResource());
        }
        return super.getDiff(element);
    }

    protected boolean isIncludeOverlays() {
        return true;
    }

    protected boolean isBusy(Object element) {
        if (element instanceof ModelResource) {
            ModelResource mr = (ModelResource)((Object)element);
            boolean busy = this.getContext().getDiffTree().getProperty(mr.getResource().getFullPath(), 1);
            if (!busy && mr instanceof ModelObjectDefinitionFile) {
                ModelObjectDefinitionFile modFile = (ModelObjectDefinitionFile)mr;
                try {
                    ModelObjectElementFile[] children;
                    ModelObjectElementFile[] modelObjectElementFileArray = children = modFile.getModelObjectElementFiles();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ModelObjectElementFile file = modelObjectElementFileArray[n2];
                        busy = this.getContext().getDiffTree().getProperty(file.getResource().getFullPath(), 1);
                        if (!busy) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    FileSystemPlugin.log(e);
                }
            }
            return busy;
        }
        return super.isBusy(element);
    }

    protected boolean hasDecendantConflicts(Object element) {
        if (element instanceof ModelResource) {
            ModelResource mr = (ModelResource)((Object)element);
            boolean conflict = this.getContext().getDiffTree().getProperty(mr.getResource().getFullPath(), 2);
            if (!conflict && mr instanceof ModelObjectDefinitionFile) {
                ModelObjectDefinitionFile modFile = (ModelObjectDefinitionFile)mr;
                try {
                    ModelObjectElementFile[] children;
                    ModelObjectElementFile[] modelObjectElementFileArray = children = modFile.getModelObjectElementFiles();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ModelObjectElementFile file = modelObjectElementFileArray[n2];
                        conflict = this.getContext().getDiffTree().getProperty(file.getResource().getFullPath(), 2);
                        if (!conflict) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    FileSystemPlugin.log(e);
                }
            }
            return conflict;
        }
        return super.hasDecendantConflicts(element);
    }
}

