/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.team.examples.pessimistic.ResourceSetContentProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ResourceChangeListener
implements IResourceDeltaVisitor,
IResourceChangeListener {
    private final Set<IResource> fAdded = new HashSet<IResource>(1);
    private final Set<IResource> fRemoved = new HashSet<IResource>(1);

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource != null) {
            IProject project = resource.getProject();
            if (project != null) {
                PessimisticFilesystemProvider provider = (PessimisticFilesystemProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.pessimistic.pessimisticnature");
                if (provider == null) {
                    return false;
                }
                if (provider.isControlled(resource)) {
                    switch (delta.getKind()) {
                        case 1: 
                        case 4: {
                            return true;
                        }
                        case 2: {
                            this.fRemoved.add(resource);
                            return false;
                        }
                    }
                } else {
                    switch (delta.getKind()) {
                        case 2: 
                        case 4: {
                            return true;
                        }
                        case 1: {
                            if (!provider.isIgnored(resource)) {
                                this.fAdded.add(resource);
                            }
                            return true;
                        }
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private IResource[] toResourceArray(Collection<IResource> collection) {
        if (collection.isEmpty()) {
            return new IResource[0];
        }
        IResource[] resources = new IResource[collection.size()];
        collection.toArray(resources);
        return resources;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            e.printStackTrace();
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Exceptions during resource callback");
        }
        if (!this.fRemoved.isEmpty() || !this.fAdded.isEmpty()) {
            IWorkspaceRunnable workspaceRunnable = monitor -> {
                if (!this.fRemoved.isEmpty()) {
                    this.remove(monitor);
                }
                if (!this.fAdded.isEmpty()) {
                    this.add(monitor);
                }
            };
            Runnable run = () -> {
                try {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    if (workspace != null) {
                        workspace.run(workspaceRunnable, null);
                    }
                }
                catch (CoreException e) {
                    PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problems encountered during attempt to add/remove control.");
                }
            };
            new Thread(run).start();
        }
    }

    private int getAddToControlPreference() {
        Preferences preferences = PessimisticFilesystemProviderPlugin.getInstance().getPluginPreferences();
        return preferences.getInt("org.eclipse.team.examples.pessimistic.AddToControl");
    }

    private void add(IProgressMonitor monitor) {
        switch (this.getAddToControlPreference()) {
            case 4: {
                break;
            }
            case 2: {
                this.addToControl(this.fAdded, monitor);
                break;
            }
            case 1: {
                Shell shell = this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    HashSet<IResource> resources = new HashSet<IResource>(this.fAdded);
                    Runnable run = () -> {
                        Object[] results;
                        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new ResourceSetContentProvider(resources));
                        dialog.setMessage("Select the resources to be added to the control of the repository.");
                        dialog.setTitle("Add resources to control");
                        dialog.setContainerMode(true);
                        dialog.setBlockOnOpen(true);
                        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                        Object[] resourceArray = resources.toArray();
                        dialog.setExpandedElements(resourceArray);
                        dialog.setInitialSelections(resourceArray);
                        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                        int status = dialog.open();
                        if (status == 0 && (results = dialog.getResult()) != null) {
                            HashSet<IResource> resources1 = new HashSet<IResource>(results.length);
                            Object[] objectArray = results;
                            int n = results.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object result = objectArray[n2];
                                resources1.add((IResource)result);
                                ++n2;
                            }
                            this.addToControl(resources1, monitor);
                        }
                    };
                    Display display = shell.getDisplay();
                    display.asyncExec(run);
                    break;
                }
                PessimisticFilesystemProviderPlugin.getInstance().logError(null, "Could not aquire a shell");
            }
        }
        this.fAdded.clear();
    }

    private void addToControl(Collection<IResource> resources, IProgressMonitor monitor) {
        Map<IProject, Set<IResource>> byProject = this.sortByProject(resources);
        for (IProject project : byProject.keySet()) {
            PessimisticFilesystemProvider provider = (PessimisticFilesystemProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.pessimistic.pessimisticnature");
            if (provider == null) continue;
            provider.addToControl(this.toResourceArray((Collection<IResource>)byProject.get(project)), monitor);
        }
    }

    private void remove(IProgressMonitor monitor) {
        Map<IProject, Set<IResource>> byProject = this.sortByProject(this.fRemoved);
        for (IProject project : byProject.keySet()) {
            PessimisticFilesystemProvider provider = (PessimisticFilesystemProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.pessimistic.pessimisticnature");
            if (provider == null) continue;
            provider.removeFromControl(this.toResourceArray((Collection<IResource>)byProject.get(project)), monitor);
        }
        this.fRemoved.clear();
    }

    private Map<IProject, Set<IResource>> sortByProject(Collection<IResource> resources) {
        HashMap<IProject, Set<IResource>> byProject = new HashMap<IProject, Set<IResource>>();
        for (IResource resource : resources) {
            IProject project = resource.getProject();
            HashSet<IResource> set = (HashSet<IResource>)byProject.get(project);
            if (set == null) {
                set = new HashSet<IResource>(1);
                byProject.put(project, set);
            }
            set.add(resource);
        }
        return byProject;
    }

    private Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchWindow[] windows;
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window == null && (windows = workbench.getWorkbenchWindows()) != null && windows.length > 0) {
                window = windows[0];
            }
            if (window != null) {
                Shell shell = window.getShell();
                if (shell == null) {
                    return null;
                }
                if (shell.isDisposed()) {
                    return null;
                }
                return shell;
            }
        }
        return null;
    }

    public void startup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Resource callback registered");
        }
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Resource callback unregistered");
        }
    }
}

