/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceSetContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Map<IResource, Set<IResource>> fResourceTree = new HashMap<IResource, Set<IResource>>(1);
    private final IResource[] fRoots;

    public ResourceSetContentProvider(Set<IResource> resources) {
        HashSet<IResource> roots = new HashSet<IResource>(resources);
        for (IResource resource : resources) {
            IContainer parent;
            if (resource.getType() == 8 || !roots.contains(parent = resource.getParent())) continue;
            roots.remove(resource);
            Set<IResource> set = this.fResourceTree.get(parent);
            if (set == null) {
                set = new HashSet<IResource>(1);
                this.fResourceTree.put((IResource)parent, set);
            }
            set.add(resource);
        }
        this.fRoots = roots.toArray(new IResource[roots.size()]);
    }

    public Object[] getChildren(Object parentElement) {
        Set<IResource> set = this.fResourceTree.get(parentElement);
        if (set != null) {
            return set.toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.fResourceTree.get(element) != null;
    }

    public Object[] getElements(Object inputElement) {
        return this.fRoots;
    }

    public void dispose() {
        this.fResourceTree = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

