/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic.ui;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.team.examples.pessimistic.ui.PessimisticProviderAction;

public class DisconnectAction
extends PessimisticProviderAction {
    public void run(IAction action) {
        IResource[] resources;
        if (PessimisticFilesystemProviderPlugin.getInstance().isDebugging()) {
            System.out.println("Disconnect");
        }
        if ((resources = this.getSelectedResources()) == null || resources.length == 0) {
            return;
        }
        HashSet<IProject> projects = new HashSet<IProject>(resources.length);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 4) {
                projects.add(resource.getProject());
            }
            ++n2;
        }
        if (!projects.isEmpty()) {
            IRunnableWithProgress runnable = monitor -> {
                IWorkspaceRunnable runnable1 = monitor1 -> {
                    for (IProject project : projects) {
                        PessimisticFilesystemProvider provider = this.getProvider((IResource)project);
                        if (provider == null) continue;
                        try {
                            RepositoryProvider.unmap((IProject)project);
                        }
                        catch (TeamException e1) {
                            PessimisticFilesystemProviderPlugin.getInstance().logError(e1, "Could not unmap " + String.valueOf(project));
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(runnable1, monitor);
                }
                catch (CoreException e2) {
                    PessimisticFilesystemProviderPlugin.getInstance().logError(e2, "Problem during unmap runnable");
                }
            };
            this.runWithProgressDialog(runnable);
        }
    }

    @Override
    protected boolean shouldEnableFor(IResource resource) {
        if (resource.getType() == 4) {
            PessimisticFilesystemProvider provider = this.getProvider(resource);
            return provider != null;
        }
        return false;
    }
}

