/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PessimisticPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Combo filesAreEditedCombo;
    private Combo filesAreEditedNoPromptCombo;
    private Combo filesAreSavedCombo;
    private Combo addToControlCombo;
    private Button changeFileContents;
    private Button failValidateEdit;
    private static final String[] EDIT_OPTION_STRINGS = new String[]{"Prompt to checkout", "Checkout", "Do nothing"};
    private static final int[] EDIT_OPTION_KEYS = new int[]{1, 2, 4};
    private static final String[] EDIT_NO_PROMPT_OPTION_STRINGS = new String[]{"Checkout", "Do nothing"};
    private static final String[] SAVE_OPTION_STRINGS = new String[]{"Checkout", "Do nothing"};
    private static final int[] SAVE_OPTION_KEYS = new int[]{2, 4};
    private static final String[] ADD_TO_CONTROL_OPTION_STRINGS = new String[]{"Prompt to add to control", "Add to control", "Do nothing"};
    private static final int[] ADD_TO_CONTROL_OPTION_KEYS = new int[]{1, 2, 4};

    protected IPreferenceStore doGetPreferenceStore() {
        return PessimisticFilesystemProviderPlugin.getInstance().getPreferenceStore();
    }

    protected void setDefaultLayout(Composite group, int columns) {
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData data = new GridData(784);
        layout.numColumns = columns;
        group.setLayoutData((Object)data);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setDefaultLayout(composite, 1);
        Composite options = new Composite(composite, 0);
        this.setDefaultLayout(options, 2);
        Label label = new Label(options, 0);
        label.setText("File handling:");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(options, 0);
        label.setText("When checked in files are edited:");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.filesAreEditedCombo = new Combo(options, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        this.filesAreEditedCombo.setLayoutData((Object)gridData);
        this.filesAreEditedCombo.setItems(EDIT_OPTION_STRINGS);
        label = new Label(options, 0);
        label.setText("When checked in files are edited programmatically:");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.filesAreEditedNoPromptCombo = new Combo(options, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        this.filesAreEditedNoPromptCombo.setLayoutData((Object)gridData);
        this.filesAreEditedNoPromptCombo.setItems(EDIT_NO_PROMPT_OPTION_STRINGS);
        label = new Label(options, 0);
        label.setText("When checked in files are saved:");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.filesAreSavedCombo = new Combo(options, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        this.filesAreSavedCombo.setLayoutData((Object)gridData);
        this.filesAreSavedCombo.setItems(SAVE_OPTION_STRINGS);
        label = new Label(options, 0);
        label.setText("When files are created:");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.addToControlCombo = new Combo(options, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        this.addToControlCombo.setLayoutData((Object)gridData);
        this.addToControlCombo.setItems(ADD_TO_CONTROL_OPTION_STRINGS);
        options = new Composite(composite, 0);
        this.setDefaultLayout(options, 1);
        label = new Label(options, 0);
        label.setText("Error cases:");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        this.failValidateEdit = new Button(options, 16416);
        this.failValidateEdit.setText("Fail validate edit");
        gridData = new GridData();
        this.failValidateEdit.setLayoutData((Object)gridData);
        this.changeFileContents = new Button(options, 16416);
        this.changeFileContents.setText("Touch files during validate edit");
        gridData = new GridData();
        this.changeFileContents.setLayoutData((Object)gridData);
        this.updatePreferencePage();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.filesAreEditedCombo.select(this.getEditOptionIndex(store.getDefaultInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEdited")));
        this.filesAreEditedNoPromptCombo.select(this.getEditNoPromptOptionIndex(store.getDefaultInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEditedNoPrompt")));
        this.filesAreSavedCombo.select(this.getSaveOptionIndex(store.getDefaultInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreSaved")));
        this.addToControlCombo.select(this.getAddToControlOptionIndex(store.getDefaultInt("org.eclipse.team.examples.pessimistic.AddToControl")));
        this.failValidateEdit.setSelection(store.getDefaultBoolean("org.eclipse.team.examples.pessimistic.FailValidateEdit"));
        this.changeFileContents.setSelection(store.getDefaultBoolean("org.eclipse.team.examples.pessimistic.ChangeFileContents"));
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        int selectionIndex = this.filesAreEditedCombo.getSelectionIndex();
        if (selectionIndex != -1) {
            store.setValue("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEdited", EDIT_OPTION_KEYS[selectionIndex]);
        }
        if ((selectionIndex = this.filesAreEditedNoPromptCombo.getSelectionIndex()) != -1) {
            store.setValue("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEditedNoPrompt", SAVE_OPTION_KEYS[selectionIndex]);
        }
        if ((selectionIndex = this.filesAreSavedCombo.getSelectionIndex()) != -1) {
            store.setValue("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreSaved", SAVE_OPTION_KEYS[selectionIndex]);
        }
        if ((selectionIndex = this.addToControlCombo.getSelectionIndex()) != -1) {
            store.setValue("org.eclipse.team.examples.pessimistic.AddToControl", ADD_TO_CONTROL_OPTION_KEYS[selectionIndex]);
        }
        store.setValue("org.eclipse.team.examples.pessimistic.FailValidateEdit", this.failValidateEdit.getSelection());
        store.setValue("org.eclipse.team.examples.pessimistic.ChangeFileContents", this.changeFileContents.getSelection());
        return true;
    }

    protected void updatePreferencePage() {
        IPreferenceStore store = this.getPreferenceStore();
        this.filesAreEditedCombo.select(this.getEditOptionIndex(store.getInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEdited")));
        this.filesAreEditedNoPromptCombo.select(this.getEditNoPromptOptionIndex(store.getInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreEditedNoPrompt")));
        this.filesAreSavedCombo.select(this.getSaveOptionIndex(store.getInt("org.eclipse.team.examples.pessimistic.WhenCheckedInFilesAreSaved")));
        this.addToControlCombo.select(this.getAddToControlOptionIndex(store.getInt("org.eclipse.team.examples.pessimistic.AddToControl")));
        this.failValidateEdit.setSelection(store.getBoolean("org.eclipse.team.examples.pessimistic.FailValidateEdit"));
        this.changeFileContents.setSelection(store.getBoolean("org.eclipse.team.examples.pessimistic.ChangeFileContents"));
    }

    protected int getEditOptionIndex(int key) {
        int i = 0;
        while (i < EDIT_OPTION_KEYS.length) {
            if (EDIT_OPTION_KEYS[i] == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getSaveOptionIndex(int key) {
        int i = 0;
        while (i < SAVE_OPTION_KEYS.length) {
            if (SAVE_OPTION_KEYS[i] == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getEditNoPromptOptionIndex(int key) {
        int i = 0;
        while (i < SAVE_OPTION_KEYS.length) {
            if (SAVE_OPTION_KEYS[i] == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int getAddToControlOptionIndex(int key) {
        int i = 0;
        while (i < ADD_TO_CONTROL_OPTION_KEYS.length) {
            if (ADD_TO_CONTROL_OPTION_KEYS[i] == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

