/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProviderPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class PessimisticProviderAction
implements IObjectActionDelegate {
    protected ISelection fSelection;
    protected Shell fShell;

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
        boolean enabled = action.isEnabled();
        if (enabled != this.checkEnablement()) {
            action.setEnabled(!enabled);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.fShell = part.getSite().getShell();
    }

    protected abstract boolean shouldEnableFor(IResource var1);

    protected boolean checkEnablement() {
        IResource[] resources = this.getSelectedResources();
        if (resources == null || resources.length == 0) {
            return false;
        }
        boolean enabled = false;
        int i = 0;
        while (!enabled && i < resources.length) {
            if (this.shouldEnableFor(resources[i])) {
                enabled = true;
            }
            ++i;
        }
        return enabled;
    }

    protected IResource[] getSelectedResources() {
        ArrayList<IResource> resources = null;
        if (!this.fSelection.isEmpty()) {
            resources = new ArrayList<IResource>();
            for (Object next : (IStructuredSelection)this.fSelection) {
                IAdaptable a;
                Object adapter;
                if (next instanceof IResource) {
                    resources.add((IResource)next);
                    continue;
                }
                if (!(next instanceof IAdaptable) || !((adapter = (a = (IAdaptable)next).getAdapter(IResource.class)) instanceof IResource)) continue;
                resources.add((IResource)adapter);
            }
        }
        if (resources != null && !resources.isEmpty()) {
            IResource[] result = new IResource[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new IResource[0];
    }

    protected boolean isControlled(IResource resource) {
        PessimisticFilesystemProvider provider = this.getProvider(resource);
        if (provider == null) {
            return false;
        }
        return provider.isControlled(resource);
    }

    protected boolean isCheckedOut(IResource resource) {
        PessimisticFilesystemProvider provider = this.getProvider(resource);
        if (provider == null) {
            return false;
        }
        return provider.isCheckedout(resource);
    }

    protected boolean isIgnored(IResource resource) {
        PessimisticFilesystemProvider provider = this.getProvider(resource);
        if (provider == null) {
            return false;
        }
        return provider.isIgnored(resource);
    }

    protected PessimisticFilesystemProvider getProvider(IResource resource) {
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        return (PessimisticFilesystemProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.pessimistic.pessimisticnature");
    }

    protected void recursivelyAdd(IResource resource, Set<IResource> resources) {
        if (this.isControlled(resource) && !this.isIgnored(resource)) {
            if (this.shouldEnableFor(resource)) {
                resources.add(resource);
            }
            if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                IResource[] members = null;
                try {
                    members = container.members();
                }
                catch (CoreException e) {
                    PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Exception traversing members");
                }
                if (members != null) {
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        this.recursivelyAdd(member, resources);
                        ++n2;
                    }
                }
            }
        }
    }

    protected Map<IProject, Set<IResource>> sortByProject(Set<IResource> resources) {
        HashMap<IProject, Set<IResource>> byProject = new HashMap<IProject, Set<IResource>>();
        if (resources != null) {
            for (IResource resource : resources) {
                IProject project = resource.getProject();
                HashSet<IResource> set = (HashSet<IResource>)byProject.get(project);
                if (set == null) {
                    set = new HashSet<IResource>(1);
                    byProject.put(project, set);
                }
                set.add(resource);
            }
        }
        return byProject;
    }

    protected void runWithProgressDialog(IRunnableWithProgress runnable) {
        try {
            new ProgressMonitorDialog(this.fShell).run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problems running action " + String.valueOf(this));
        }
        catch (InterruptedException e) {
            PessimisticFilesystemProviderPlugin.getInstance().logError(e, "Problems running action " + String.valueOf(this));
        }
    }
}

