/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.pessimistic.ui;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.examples.pessimistic.PessimisticFilesystemProvider;
import org.eclipse.team.examples.pessimistic.ui.PessimisticProviderAction;

public abstract class SourceManagementAction
extends PessimisticProviderAction {
    public void run(IAction action) {
        IResource[] resources = this.getSelectedResources();
        if (resources == null || resources.length == 0) {
            return;
        }
        HashSet<IResource> resourceSet = new HashSet<IResource>(resources.length);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.recursivelyAdd(resource, resourceSet);
            ++n2;
        }
        if (!resourceSet.isEmpty()) {
            Map<IProject, Set<IResource>> byProject = this.sortByProject(resourceSet);
            IRunnableWithProgress runnable = monitor -> {
                for (IProject project : byProject.keySet()) {
                    PessimisticFilesystemProvider provider = this.getProvider((IResource)project);
                    if (provider == null) continue;
                    Set set = (Set)byProject.get(project);
                    IResource[] resources1 = new IResource[set.size()];
                    set.toArray(resources1);
                    this.manageResources(provider, resources1, monitor);
                }
            };
            this.runWithProgressDialog(runnable);
        }
    }

    protected abstract void manageResources(PessimisticFilesystemProvider var1, IResource[] var2, IProgressMonitor var3);
}

