/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueImpl;
import org.eclipse.e4.ui.css.core.resources.CSSResourcesHelpers;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.css.CSSValue;

public class CSSResourcesHelpersTest
extends CSSSWTHelperTestCase {
    @Test
    void testGetCSSValueKeyWhenFont() {
        CSS2FontProperties fontProperties = this.fontProperties("Arial", 10, null, null);
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)CSSResourcesHelpers.getCSSFontPropertiesKey((CSS2FontProperties)fontProperties), (Object)result);
    }

    @Test
    void testGetCSSValueKeyWhenDefinitionAsFontFamily() {
        CSS2FontProperties fontProperties = this.fontProperties(this.addFontDefinitionMarker("symbolicName"), 10, null, null);
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)CSSResourcesHelpers.getCSSFontPropertiesKey((CSS2FontProperties)fontProperties), (Object)result);
    }

    @Test
    void testGetCSSValueKeyWhenRgbAsColorValue() {
        CSSValueImpl colorValue = this.colorValue("rgb(255,0,0)");
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"rgb(255,0,0)", (Object)result);
    }

    @Test
    void testGetCSSValueKeyWhenDefinitionAsColorValue() {
        CSSValueImpl colorValue = this.colorValue(this.addColorDefinitionMarker("symbolicName"));
        String result = CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"#symbolicName", (Object)result);
    }
}

