/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueImpl;
import org.eclipse.e4.ui.css.core.resources.CSSResourcesHelpers;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.eclipse.e4.ui.css.swt.resources.ResourceByDefinitionKey;
import org.eclipse.e4.ui.css.swt.resources.SWTResourceRegistryKeyFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.css.CSSValue;

public class SWTResourceRegistryKeyFactoryTest
extends CSSSWTHelperTestCase {
    private final SWTResourceRegistryKeyFactory factory = new SWTResourceRegistryKeyFactory();

    @Test
    void testCreateKeyWhenFontProperty() {
        CSS2FontProperties fontProperties = this.fontProperties("Arial", 12, CSS_ITALIC, CSS_BOLD);
        Object result = this.factory.createKey((CSSValue)fontProperties);
        Assertions.assertEquals(String.class, result.getClass());
        Assertions.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties), (Object)result);
    }

    @Test
    void testCreateKeyWhenColorValue() {
        CSSValueImpl colorValue = this.colorValue("red");
        Object result = this.factory.createKey((CSSValue)colorValue);
        Assertions.assertEquals(String.class, result.getClass());
        Assertions.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue), (Object)result);
    }

    @Test
    void testCreateKeyWhenFontByDefinition() {
        CSS2FontProperties fontProperties = null;
        try {
            fontProperties = this.fontProperties("#font-by-definition", 12, CSS_ITALIC, CSS_BOLD);
        }
        catch (Exception e) {
            Assertions.fail((String)"FontProperties should not throw exception");
        }
        Object result = this.factory.createKey((CSSValue)fontProperties);
        Assertions.assertEquals(ResourceByDefinitionKey.class, result.getClass());
        Assertions.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)fontProperties), (Object)result.toString());
    }

    @Test
    void testCreateKeyWhenColorByDefinition() {
        CSSValueImpl colorValue = this.colorValue("#color-by-definition");
        Object result = this.factory.createKey((CSSValue)colorValue);
        Assertions.assertEquals(ResourceByDefinitionKey.class, result.getClass());
        Assertions.assertEquals((Object)CSSResourcesHelpers.getCSSValueKey((CSSValue)colorValue), (Object)result.toString());
    }
}

