/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.w3c.dom.css.CSSValue;

public class CSSSWTColorHelperTest
extends CSSSWTHelperTestCase {
    private Display display;

    @BeforeEach
    public void setUp() {
        this.display = Display.getDefault();
    }

    @Test
    void testGetSWTColor() {
        Color result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue("red"), (Display)this.display);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)255, (int)result.getRed());
        Assertions.assertEquals((int)0, (int)result.getBlue());
        Assertions.assertEquals((int)0, (int)result.getGreen());
    }

    @Test
    void testGetSWTColorWhenNotSupportedColorType() {
        Color result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue("123213", (short)3), (Display)this.display);
        Assertions.assertNull((Object)result);
    }

    @Test
    void testGetSWTColorWhenInvalidColorValue() {
        Color result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue("asdsad12"), (Display)this.display);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.getRed());
        Assertions.assertEquals((int)0, (int)result.getBlue());
        Assertions.assertEquals((int)0, (int)result.getGreen());
    }

    @Test
    void testGetSWTColorWhenColorFromDefinition() {
        this.registerColorProviderWith("org.eclipse.jdt.debug.ui.InDeadlockColor", new RGB(0, 255, 0));
        Color result = CSSSWTColorHelper.getSWTColor((CSSValue)this.colorValue(this.addColorDefinitionMarker("org-eclipse-jdt-debug-ui-InDeadlockColor")), (Display)this.display);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.getRed());
        Assertions.assertEquals((int)0, (int)result.getBlue());
        Assertions.assertEquals((int)255, (int)result.getGreen());
    }
}

