/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTFontHelper;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTHelperTestCase;
import org.eclipse.swt.graphics.FontData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CSSSWTFontHelperTest
extends CSSSWTHelperTestCase {
    @Test
    void testGetFontData() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, CSS_ITALIC, CSS_BOLD), (FontData)new FontData());
        Assertions.assertEquals((Object)"Times", (Object)result.getName());
        Assertions.assertEquals((int)11, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataWithoutOldFont() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, CSS_ITALIC, CSS_BOLD), null);
        Assertions.assertEquals((Object)"Times", (Object)result.getName());
        Assertions.assertEquals((int)11, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataStyledFont() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, "normal", "normal"), (FontData)new FontData("Courier", 11, 3));
        Assertions.assertEquals((Object)"Times", (Object)result.getName());
        Assertions.assertEquals((int)11, (int)result.getHeight());
        Assertions.assertEquals((int)0, (int)result.getStyle());
    }

    @Test
    void testGetFontDataWhenMissingFamilyInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(null, 11, CSS_ITALIC, CSS_BOLD), (FontData)new FontData("Courier", 5, 0));
        Assertions.assertEquals((Object)"Courier", (Object)result.getName());
        Assertions.assertEquals((int)11, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataWhenMissingSizeInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Arial", null, CSS_ITALIC, CSS_BOLD), (FontData)new FontData("Courier", 5, 0));
        Assertions.assertEquals((Object)"Arial", (Object)result.getName());
        Assertions.assertEquals((int)5, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataWhenMissingStyleInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, null, CSS_BOLD), (FontData)new FontData("Courier", 5, 2));
        Assertions.assertEquals((Object)"Times", (Object)result.getName());
        Assertions.assertEquals((int)11, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataWhenMissingWeightInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties("Times", 11, CSS_ITALIC, null), (FontData)new FontData("Courier", 5, 1));
        Assertions.assertEquals((Object)"Times", (Object)result.getName());
        Assertions.assertEquals((int)11, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataWhenMissingAllInCss() {
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(null, null, null, null), (FontData)new FontData("Courier", 11, 3));
        Assertions.assertEquals((Object)"Courier", (Object)result.getName());
        Assertions.assertEquals((int)11, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataWhenFontFamilyFromDefinitionAndOverwritingSize() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 3);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont"), 10, null, null), (FontData)new FontData());
        Assertions.assertEquals((Object)"Arial", (Object)result.getName());
        Assertions.assertEquals((int)10, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataWhenFontFamilyFromDefinitionAndOverwritingStyle() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 1);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont"), null, CSS_ITALIC, null), (FontData)new FontData());
        Assertions.assertEquals((Object)"Arial", (Object)result.getName());
        Assertions.assertEquals((int)15, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataWhenFontFamilyFromDefinitionAndOverwritingWeight() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 2);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont"), null, null, CSS_BOLD), (FontData)new FontData());
        Assertions.assertEquals((Object)"Arial", (Object)result.getName());
        Assertions.assertEquals((int)15, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }

    @Test
    void testGetFontDataFromFontDefinition() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", "Arial", 15, 3);
        FontData result = CSSSWTFontHelper.getFontData((CSS2FontProperties)this.fontProperties(this.addFontDefinitionMarker("org-eclipse-jface-bannerfont")), (FontData)new FontData());
        Assertions.assertEquals((Object)"Arial", (Object)result.getName());
        Assertions.assertEquals((int)15, (int)result.getHeight());
        Assertions.assertEquals((int)3, (int)result.getStyle());
    }
}

