/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.impl.dom.CSSValueImpl;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.mockito.Mockito;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.DOMException;

public abstract class CSSSWTHelperTestCase {
    protected static final String CSS_ITALIC = CSS2FontHelper.getFontStyle((boolean)true);
    protected static final String CSS_BOLD = CSS2FontHelper.getFontWeight((boolean)true);

    protected void registerFontProviderWith(String expectedSymbolicName, String family, int size, int style) {
        IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
        ((IColorAndFontProvider)Mockito.doReturn((Object)new FontData[]{new FontData(family, size, style)}).when((Object)provider)).getFont(expectedSymbolicName);
        this.registerProvider(provider);
    }

    protected void registerColorProviderWith(String expectedSymbolicName, RGB rgb) {
        IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
        ((IColorAndFontProvider)Mockito.doReturn((Object)rgb).when((Object)provider)).getColor(expectedSymbolicName);
        this.registerProvider(provider);
    }

    private void registerProvider(IColorAndFontProvider provider) {
        FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(IColorAndFontProvider.class, (Object)provider, null);
    }

    protected CSS2FontProperties fontProperties(String family) {
        return this.fontProperties(family, null, null, null);
    }

    protected CSS2FontProperties fontProperties(String family, Object size, Object style, Object weight) {
        CSS2FontProperties result = (CSS2FontProperties)Mockito.mock(CSS2FontProperties.class);
        ((CSS2FontProperties)Mockito.doReturn((Object)this.valueImpl(family)).when((Object)result)).getFamily();
        if (size != null) {
            ((CSS2FontProperties)Mockito.doReturn((Object)this.valueImpl(size)).when((Object)result)).getSize();
        }
        if (style != null) {
            ((CSS2FontProperties)Mockito.doReturn((Object)this.valueImpl(style)).when((Object)result)).getStyle();
        }
        if (weight != null) {
            ((CSS2FontProperties)Mockito.doReturn((Object)this.valueImpl(weight)).when((Object)result)).getWeight();
        }
        return result;
    }

    private CSSValueImpl valueImpl(final Object value) {
        if (value != null) {
            return new CSSValueImpl(){

                public String getCssText() {
                    return value.toString();
                }

                public String getStringValue() {
                    return this.getCssText();
                }

                public float getFloatValue(short valueType) throws DOMException {
                    return Float.parseFloat(this.getCssText());
                }
            };
        }
        return null;
    }

    protected CSSValueImpl colorValue(String value) {
        return this.colorValue(value, (short)1);
    }

    protected CSSValueImpl colorValue(String value, short type) {
        CSSValueImpl result = (CSSValueImpl)Mockito.mock(CSSValueImpl.class);
        ((CSSValueImpl)Mockito.doReturn((Object)19).when((Object)result)).getPrimitiveType();
        ((CSSValueImpl)Mockito.doReturn((Object)type).when((Object)result)).getCssValueType();
        ((CSSValueImpl)Mockito.doReturn((Object)value).when((Object)result)).getStringValue();
        ((CSSValueImpl)Mockito.doReturn((Object)value).when((Object)result)).getCssText();
        return result;
    }

    protected String addFontDefinitionMarker(String fontDefinitionId) {
        return "#" + fontDefinitionId;
    }

    protected String addColorDefinitionMarker(String colorDefinitionId) {
        return "#" + colorDefinitionId;
    }
}

