/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.helpers;

import java.util.List;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.ui.css.swt.helpers.EclipsePreferencesHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EclipsePreferencesHelperTest {
    @Test
    void testAppendOverriddenPropertyName() {
        IEclipsePreferences preferences = (IEclipsePreferences)Mockito.spy((Object)new EclipsePreferences());
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop1");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop2");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop3");
        String overriddenPreferences = preferences.get("overriddenByCSS", "");
        Assertions.assertTrue((boolean)overriddenPreferences.contains(",prop1,"));
        Assertions.assertTrue((boolean)overriddenPreferences.contains(",prop2,"));
        Assertions.assertTrue((boolean)overriddenPreferences.contains(",prop3,"));
        ((IEclipsePreferences)Mockito.verify((Object)preferences, (VerificationMode)Mockito.times((int)1))).addPreferenceChangeListener(EclipsePreferencesHelper.getPreferenceChangeListener());
    }

    @Test
    void testGetOverriddenPropertyNames() {
        EclipsePreferences preferences = new EclipsePreferences();
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop1");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop2");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop3");
        List propertyNames = EclipsePreferencesHelper.getOverriddenPropertyNames((IEclipsePreferences)preferences);
        Assertions.assertEquals((int)3, (int)propertyNames.size());
        Assertions.assertTrue((boolean)propertyNames.add("prop1"));
        Assertions.assertTrue((boolean)propertyNames.add("prop2"));
        Assertions.assertTrue((boolean)propertyNames.add("prop3"));
    }

    @Test
    void testRemoveOverriddenPropertyNames() {
        IEclipsePreferences preferences = (IEclipsePreferences)Mockito.spy((Object)new EclipsePreferences());
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop1");
        EclipsePreferencesHelper.removeOverriddenPropertyNames((IEclipsePreferences)preferences);
        Assertions.assertNull((Object)preferences.get("overriddenByCSS", null));
        ((IEclipsePreferences)Mockito.verify((Object)preferences, (VerificationMode)Mockito.times((int)1))).removePreferenceChangeListener(EclipsePreferencesHelper.getPreferenceChangeListener());
    }

    @Test
    void testRemoveOverriddenByCssProperty() {
        EclipsePreferences preferences = new EclipsePreferences();
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop1");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop2");
        EclipsePreferencesHelper.appendOverriddenPropertyName((IEclipsePreferences)preferences, (String)"prop3");
        EclipsePreferencesHelper.removeOverriddenByCssProperty((IEclipsePreferences)preferences, (String)"prop2");
        String overriddenPreferences = preferences.get("overriddenByCSS", "");
        Assertions.assertTrue((boolean)overriddenPreferences.contains(",prop1,"));
        Assertions.assertFalse((boolean)overriddenPreferences.contains(",prop2,"));
        Assertions.assertTrue((boolean)overriddenPreferences.contains(",prop3,"));
    }
}

