/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.forms;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.ToggleHyperlink;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SectionTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);

    protected Section createTestSection(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite compositeToTest = new Composite((Composite)shell, 0);
        compositeToTest.setLayout((Layout)new FillLayout());
        Section test = new Section((Composite)shell, 322);
        this.engine.applyStyles((Object)shell, true);
        return test;
    }

    @Test
    void testSectionColors() {
        Section section = this.createTestSection("Section { swt-titlebar-color: #FF0000;tb-toggle-color: #FF0000; tb-toggle-hover-color: #00FF00; background-color-gradient-titlebar: #00FF00; background-color-titlebar: #0000FF; border-color-titlebar: #00FF00}");
        Assertions.assertNotNull((Object)section.getTitleBarForeground());
        Assertions.assertEquals((Object)RED, (Object)section.getTitleBarForeground().getRGB());
        Assertions.assertNotNull((Object)section.getTitleBarBackground());
        Assertions.assertEquals((Object)BLUE, (Object)section.getTitleBarBackground().getRGB());
        Assertions.assertNotNull((Object)section.getTitleBarGradientBackground());
        Assertions.assertEquals((Object)GREEN, (Object)section.getTitleBarGradientBackground().getRGB());
        Assertions.assertNotNull((Object)section.getTitleBarBorderColor());
        Assertions.assertEquals((Object)GREEN, (Object)section.getTitleBarBorderColor().getRGB());
        ToggleHyperlink toggle = (ToggleHyperlink)section.getChildren()[0];
        Assertions.assertNotNull((Object)toggle.getDecorationColor());
        Assertions.assertEquals((Object)RED, (Object)toggle.getDecorationColor().getRGB());
        Assertions.assertNotNull((Object)toggle.getHoverDecorationColor());
        Assertions.assertEquals((Object)GREEN, (Object)toggle.getHoverDecorationColor().getRGB());
    }

    @Test
    void testSectionResetColors() throws Exception {
        Section section = this.createTestSection("Section { swt-titlebar-color: #FF0000;tb-toggle-color: #FF0000; tb-toggle-hover-color: #00FF00; background-color-gradient-titlebar: #00FF00; background-color-titlebar: #0000FF; border-color-titlebar: #00FF00}");
        this.engine.reset();
        Assertions.assertNull((Object)section.getTitleBarForeground());
        ToggleHyperlink toggle = (ToggleHyperlink)section.getChildren()[0];
        Assertions.assertNull((Object)toggle.getDecorationColor());
        Assertions.assertNull((Object)toggle.getHoverDecorationColor());
    }
}

