/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.properties.tabbed;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TabbedPropertiesTitleTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    private TabbedPropertySheetWidgetFactory factory;
    private Shell shell;

    private TabbedPropertyTitle createTabbedPropertiesTitle(String stylesheet) {
        String s = stylesheet == null ? "TabbedPropertyTitle { swt-backgroundGradientStart-color: #FF0000; swt-backgroundGradientEnd-color: #FF0000; swt-backgroundBottomKeyline1-color: #FF0000; swt-backgroundBottomKeyline2-color: #FF0000;}" : stylesheet;
        this.engine = this.createEngine(s, this.display);
        this.shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        this.shell.setLayout((Layout)layout);
        Composite compositeToTest = new Composite((Composite)this.shell, 0);
        compositeToTest.setLayout((Layout)new FillLayout());
        this.factory = new TabbedPropertySheetWidgetFactory();
        TabbedPropertyTitle title = new TabbedPropertyTitle(compositeToTest, this.factory);
        this.shell.pack();
        return title;
    }

    private void assertColor(RGB expected, String actualKey) {
        Assertions.assertNotNull((Object)this.factory.getColors().getColor(actualKey));
        Assertions.assertEquals((Object)expected, (Object)this.factory.getColors().getColor(actualKey).getRGB());
    }

    @Test
    void titleBackgroundColorIsStyled() {
        this.createTabbedPropertiesTitle(null);
        this.engine.applyStyles((Object)this.shell, true);
        this.assertColor(RED, "org.eclipse.ui.forms.H_GRADIENT_START");
        this.assertColor(RED, "org.eclipse.ui.forms.H_GRADIENT_END");
        this.assertColor(RED, "org.eclipse.ui.forms.H_BOTTOM_KEYLINE1");
        this.assertColor(RED, "org.eclipse.ui.forms.H_BOTTOM_KEYLINE2");
    }

    @Test
    void titleBackgroundColorIsStyledAndReset() {
        this.createTabbedPropertiesTitle(null);
        RGB colorGradStartBeforStyling = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START").getRGB();
        RGB colorGradEndBeforStyling = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END").getRGB();
        RGB colorBottomKeylineOneBeforStyling = this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1").getRGB();
        RGB colorBottomKeylineTwoBeforStyling = this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2").getRGB();
        this.engine.applyStyles((Object)this.shell, true);
        this.engine.reset();
        this.assertColor(colorGradStartBeforStyling, "org.eclipse.ui.forms.H_GRADIENT_START");
        this.assertColor(colorGradEndBeforStyling, "org.eclipse.ui.forms.H_GRADIENT_END");
        this.assertColor(colorBottomKeylineOneBeforStyling, "org.eclipse.ui.forms.H_BOTTOM_KEYLINE1");
        this.assertColor(colorBottomKeylineTwoBeforStyling, "org.eclipse.ui.forms.H_BOTTOM_KEYLINE2");
    }

    @Test
    void colorsAreNotChangedWhenNoStyleGivenInCss() {
        this.createTabbedPropertiesTitle("SomeOtherWidget { h-gradient-start-color: #FF0000; h-gradient-end-color: #FF0000; h-bottom-keyline-1-color: #FF0000; h-bottom-keyline-2-color: #FF0000;}");
        RGB colorGradStartBeforStyling = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START").getRGB();
        RGB colorGradEndBeforStyling = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END").getRGB();
        RGB colorBottomKeylineOneBeforStyling = this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1").getRGB();
        RGB colorBottomKeylineTwoBeforStyling = this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2").getRGB();
        this.engine.applyStyles((Object)this.shell, true);
        this.assertColor(colorGradStartBeforStyling, "org.eclipse.ui.forms.H_GRADIENT_START");
        this.assertColor(colorGradEndBeforStyling, "org.eclipse.ui.forms.H_GRADIENT_END");
        this.assertColor(colorBottomKeylineOneBeforStyling, "org.eclipse.ui.forms.H_BOTTOM_KEYLINE1");
        this.assertColor(colorBottomKeylineTwoBeforStyling, "org.eclipse.ui.forms.H_BOTTOM_KEYLINE2");
    }
}

