/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ButtonTest
extends CSSSWTTestCase {
    protected Button createTestButton(String styleSheet, int buttonStyle) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Button buttonToTest = new Button(panel, buttonStyle);
        buttonToTest.setText("Some button text");
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return buttonToTest;
    }

    @Test
    void testColor() {
        Button buttonToTest = this.createTestButton("Button { background-color: #FF0000; color: #0000FF }", 32);
        Assertions.assertEquals((Object)RED, (Object)buttonToTest.getBackground().getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)buttonToTest.getForeground().getRGB());
    }

    @Test
    void testASpecificColor() {
        RGB RGB_SPECIAL = new RGB(5, 65, 105);
        Button buttonToTest = this.createTestButton("Button { background-color: #054169; color: #054169; }", 8);
        Assertions.assertEquals((Object)RGB_SPECIAL, (Object)buttonToTest.getBackground().getRGB());
        Assertions.assertEquals((Object)RGB_SPECIAL, (Object)buttonToTest.getForeground().getRGB());
    }

    @Test
    void testFontRegular() {
        Button buttonToTest = this.createTestButton("Button { font: Verdana 16px }", 32);
        Assertions.assertEquals((int)1, (int)buttonToTest.getFont().getFontData().length);
        FontData fontData = buttonToTest.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assertions.assertEquals((int)16, (int)fontData.getHeight());
        Assertions.assertEquals((int)0, (int)fontData.getStyle());
    }

    @Test
    void testFontBold() {
        Button buttonToTest = this.createTestButton("Button { font: Arial 12px; font-weight: bold }", 32);
        Assertions.assertEquals((int)1, (int)buttonToTest.getFont().getFontData().length);
        FontData fontData = buttonToTest.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assertions.assertEquals((int)12, (int)fontData.getHeight());
        Assertions.assertEquals((int)1, (int)fontData.getStyle());
    }

    @Test
    void testFontItalic() {
        Button buttonToTest = this.createTestButton("Button { font-style: italic }", 32);
        Assertions.assertEquals((int)1, (int)buttonToTest.getFont().getFontData().length);
        FontData fontData = buttonToTest.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
    }

    @Disabled
    @Test
    void testSelectedPseudo() {
        Button buttonToTest = this.createTestButton("Button { color: #FF0000; }\nButton:selected { color: #0000FF; }", 32);
        Assertions.assertEquals((Object)RED, (Object)buttonToTest.getForeground().getRGB());
        buttonToTest.setSelection(true);
        this.engine.applyStyles((Object)buttonToTest.getShell(), true);
        Assertions.assertEquals((Object)BLUE, (Object)buttonToTest.getForeground().getRGB());
    }

    @Test
    void testAlignment() {
        Button buttonToTest = this.createTestButton("Button { swt-alignment: right; }", 32);
        Assertions.assertEquals((int)131072, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { swt-alignment: left; }", 32);
        Assertions.assertEquals((int)16384, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { swt-alignment: center; }", 32);
        Assertions.assertEquals((int)0x1000000, (int)buttonToTest.getAlignment());
    }

    @Test
    void testAlignment2() {
        Button buttonToTest = this.createTestButton("Button { swt-alignment: trail; }", 32);
        Assertions.assertEquals((int)131072, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { swt-alignment: lead; }", 32);
        Assertions.assertEquals((int)16384, (int)buttonToTest.getAlignment());
    }

    @Test
    void testArrowAlignment() {
        Button buttonToTest = this.createTestButton("Button { swt-alignment: up; }", 4);
        Assertions.assertEquals((int)128, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { swt-alignment: down; }", 4);
        Assertions.assertEquals((int)1024, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { swt-alignment: left; }", 4);
        Assertions.assertEquals((int)16384, (int)buttonToTest.getAlignment());
        buttonToTest = this.createTestButton("Button { swt-alignment: right; }", 4);
        Assertions.assertEquals((int)131072, (int)buttonToTest.getAlignment());
    }

    @Test
    void ensurePseudoAttributeAllowsToSelectionPushButton() {
        Button buttonToTest = this.createTestButton("Button[style~='SWT.CHECK'] { background-color: #FF0000; color: #0000FF }", 32);
        Assertions.assertEquals((Object)RED, (Object)buttonToTest.getBackground().getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)buttonToTest.getForeground().getRGB());
        Button unStyledButton = this.createTestButton("Button[style~='SWT.PUSH'] { background-color: #FF0000; color: #0000FF }", 32);
        Assertions.assertNotEquals((Object)RED, (Object)unStyledButton.getBackground().getRGB());
        Assertions.assertNotEquals((Object)BLUE, (Object)unStyledButton.getForeground().getRGB());
    }
}

