/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB WHITE = new RGB(255, 255, 255);
    protected Display display;
    protected CSSEngine engine;

    public CSSEngine createEngine(String styleSheet, Display display) {
        this.engine = new CSSSWTEngineImpl(display);
        this.engine.setErrorHandler(e -> {
            Object object = Assertions.fail((String)e.getMessage());
        });
        try {
            this.engine.parseStyleSheet((Reader)new StringReader(styleSheet));
        }
        catch (IOException e2) {
            Assertions.fail((String)e2.getMessage());
        }
        return this.engine;
    }

    @BeforeEach
    public void setUp() {
        this.display = Display.getDefault();
    }

    @AfterEach
    public void tearDown() {
        if (!this.display.isDisposed()) {
            Shell[] shellArray = this.display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                shell.dispose();
                ++n2;
            }
        }
    }

    protected Label createTestLabel(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        Label labelToTest = new Label(panel, 0);
        labelToTest.setText("Some label text");
        this.engine.applyStyles((Object)labelToTest, true);
        shell.pack();
        return labelToTest;
    }
}

