/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.util.function.Supplier;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.dom.html.SWTHTMLElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class CSSSWTWidgetTest
extends CSSSWTTestCase {
    @Disabled
    @Test
    void testEngineKey() {
        Label widget = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        Assertions.assertEquals((Object)WidgetElement.getEngine((Widget)widget), (Object)this.engine);
    }

    @Test
    void testIDKey() {
        String id = "some.test.id";
        Label widget = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        WidgetElement.setID((Widget)widget, (String)"some.test.id");
        Assertions.assertEquals((Object)WidgetElement.getID((Widget)widget), (Object)"some.test.id");
    }

    @Test
    void testCSSClassKey() {
        String cssClass = "some.test.cssclassname";
        Label widget = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        WidgetElement.setCSSClass((Widget)widget, (String)"some.test.cssclassname");
        Assertions.assertEquals((Object)WidgetElement.getCSSClass((Widget)widget), (Object)"some.test.cssclassname");
    }

    @Test
    void testHasAttribute() {
        Label widget = this.createTestLabel("Label { }");
        String propertySetToEmptyStringKey = "empty-property";
        widget.setData(propertySetToEmptyStringKey, (Object)"");
        Assertions.assertTrue((boolean)this.engine.getElement((Object)widget).hasAttribute(propertySetToEmptyStringKey));
        Assertions.assertFalse((boolean)this.engine.getElement((Object)widget).hasAttribute("foo-bar-attribute"));
        Assertions.assertNotNull((Object)widget);
    }

    @Test
    void testGetAttributeWithSwtStylesNull() {
        Label widget = this.createTestLabel("Label { }");
        this.engine.setElementProvider((element, engine) -> new WidgetElementWithSwtStylesNull((Widget)element, engine));
        Assertions.assertTrue((boolean)this.engine.getElement((Object)widget).hasAttribute("style"));
        Assertions.assertEquals((Object)"", (Object)this.engine.getElement((Object)widget).getAttribute("style"));
    }

    @Test
    void testGetAttributeWithAttributeTypeNull() {
        Label widget = this.createTestLabel("Label { }");
        this.engine.setElementProvider((element, engine) -> new SWTHTMLElementWithAttributeTypeNull((Widget)element, engine));
        Assertions.assertTrue((boolean)this.engine.getElement((Object)widget).hasAttribute("type"));
        Assertions.assertEquals((Object)"", (Object)this.engine.getElement((Object)widget).getAttribute("type"));
    }

    @Test
    void testGetAttributeWithAttributeSupplierReturningNull() {
        Label widget = this.createTestLabel("Label { }");
        this.engine.setElementProvider((element, engine) -> new WidgetElementWithSupplierReturningNull((Widget)element, engine));
        Assertions.assertThrows(AssertionFailedException.class, () -> this.lambda$3((Widget)widget));
    }

    private /* synthetic */ void lambda$3(Widget widget) throws Throwable {
        String string = this.engine.getElement((Object)widget).getAttribute("style");
    }

    private final class SWTHTMLElementWithAttributeTypeNull
    extends SWTHTMLElement {
        private SWTHTMLElementWithAttributeTypeNull(Widget widget, CSSEngine engine) {
            super(widget, engine);
            this.attributeType = null;
        }
    }

    private static final class WidgetElementWithSupplierReturningNull
    extends WidgetElement {
        private WidgetElementWithSupplierReturningNull(Widget widget, CSSEngine engine) {
            super(widget, engine);
        }

        protected Supplier<String> internalGetAttribute(String attr) {
            return () -> null;
        }
    }

    private final class WidgetElementWithSwtStylesNull
    extends WidgetElement {
        private WidgetElementWithSwtStylesNull(Widget widget, CSSEngine engine) {
            super(widget, engine);
            this.swtStyles = null;
        }
    }
}

