/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CTabFolderTest
extends CSSSWTTestCase {
    protected CTabFolder createTestCTabFolder(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        CTabFolder folderToTest = new CTabFolder(panel, 0);
        CTabItem tab1 = new CTabItem(folderToTest, 0);
        tab1.setText("A TAB ITEM");
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return folderToTest;
    }

    protected ToolBar[] createTestToolBars(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        CTabFolder folderA = new CTabFolder(panel, 0);
        CTabItem tabA = new CTabItem(folderA, 0);
        tabA.setText("FolderA TAB ITEM");
        ToolBar toolbarA = new ToolBar((Composite)folderA, 0x800100);
        folderA.setTopRight((Control)toolbarA);
        CTabFolder folderB = new CTabFolder(panel, 0);
        CTabItem tabB = new CTabItem(folderB, 0);
        tabB.setText("FolderB TAB ITEM");
        ToolBar toolbarB = new ToolBar((Composite)folderB, 0x800100);
        folderB.setTopRight((Control)toolbarB);
        ToolBar toolbarC = new ToolBar(panel, 0x800100);
        this.engine.applyStyles((Object)shell, true);
        return new ToolBar[]{toolbarA, toolbarB, toolbarC};
    }

    protected Shell createShell(String styleSheet) {
        Display display = Display.getDefault();
        this.engine = this.createEngine(styleSheet, display);
        Shell shell = new Shell(display, 0);
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return shell;
    }

    protected Label createLabelInCTabFolder(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        CTabFolder folderToTest = new CTabFolder(panel, 0);
        CTabItem tab1 = new CTabItem(folderToTest, 0);
        tab1.setText("A TAB ITEM");
        Composite composite = new Composite((Composite)folderToTest, 2048);
        composite.setLayout((Layout)new FillLayout());
        Label labelToTest = new Label(composite, 2048);
        labelToTest.setText("Text for item ");
        tab1.setControl((Control)composite);
        folderToTest.setSelection(0);
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return labelToTest;
    }

    @Test
    void testBackgroundColor() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { background-color: #0000FF }");
        Assertions.assertEquals((Object)BLUE, (Object)folderToTest.getBackground().getRGB());
    }

    @Test
    void testTextColor() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { color: #0000FF }");
        Assertions.assertEquals((Object)BLUE, (Object)folderToTest.getForeground().getRGB());
    }

    @Test
    void testFontRegular() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { font: Verdana 16px }");
        Assertions.assertEquals((int)1, (int)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assertions.assertEquals((int)16, (int)fontData.getHeight());
        Assertions.assertEquals((int)0, (int)fontData.getStyle());
    }

    @Test
    void testFontBold() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { font: Arial 12px; font-weight: bold }");
        Assertions.assertEquals((int)1, (int)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assertions.assertEquals((int)12, (int)fontData.getHeight());
        Assertions.assertEquals((int)1, (int)fontData.getStyle());
    }

    @Test
    void testFontItalic() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { font: Arial 12px; font-style: italic }");
        Assertions.assertEquals((int)1, (int)folderToTest.getFont().getFontData().length);
        FontData fontData = folderToTest.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assertions.assertEquals((int)12, (int)fontData.getHeight());
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
    }

    @Test
    void testBorderVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { border-visible: true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getBorderVisible());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "border-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { border-visible: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getBorderVisible());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "border-visible", null));
    }

    @Test
    void testSimple() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-simple: true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getSimple());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-simple", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-simple: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getSimple());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-simple", null));
    }

    @Test
    void testMaximizeVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-maximize-visible: true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getMaximizeVisible());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-maximize-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-maximize-visible: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getMaximizeVisible());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-maximize-visible", null));
    }

    @Test
    void testMinimizeVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-minimize-visible: true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getMinimizeVisible());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-minimize-visible", null));
        folderToTest.getShell().close();
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-minimize-visible: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getMinimizeVisible());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-minimize-visible", null));
    }

    @Test
    void testMaximized() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-maximized: true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getMaximized());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-maximized", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-maximized: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getMaximized());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-maximized", null));
    }

    @Test
    void testMinimized() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-minimized: true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getMinimized());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-minimized", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-minimized: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getMinimized());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-minimized", null));
    }

    @Test
    void testTabHeight() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-tab-height: 30px }");
        Assertions.assertEquals((int)30, (int)folderToTest.getTabHeight());
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-tab-height: 40px }");
        Assertions.assertEquals((int)40, (int)folderToTest.getTabHeight());
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-tab-height: 40px 50px }");
        Assertions.assertNotSame((Object)40, (Object)folderToTest.getTabHeight());
        Assertions.assertNotSame((Object)50, (Object)folderToTest.getTabHeight());
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-tab-height: 40 }");
        Assertions.assertNotSame((Object)40, (Object)folderToTest.getTabHeight());
    }

    @Test
    void testSingle() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-single: true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getSingle());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-single", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-single: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getSingle());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-single", null));
    }

    @Test
    void testUnselectedCloseVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-unselected-close-visible true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getUnselectedCloseVisible());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-unselected-close-visible", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-unselected-close-visible: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getUnselectedCloseVisible());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-unselected-close-visible", null));
    }

    @Test
    void testUnselectedImageVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-unselected-image-visible: true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getUnselectedImageVisible());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-unselected-image-visible", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-unselected-image-visible: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getUnselectedImageVisible());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-unselected-image-visible", null));
    }

    @Test
    void testRetrievePropertyNull() {
        Shell shell = this.createShell("Shell {color:red}");
        Assertions.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "border-visible", null));
        Assertions.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "swt-maximized", null));
        Assertions.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "swt-maximize-visible", null));
        Assertions.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "swt-minimize-visible", null));
        Assertions.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "swt-simple", null));
        Assertions.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "swt-single", null));
        Assertions.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "swt-unselected-close-visible", null));
        Assertions.assertEquals(null, (Object)this.engine.retrieveCSSProperty((Object)shell, "swt-unselected-image-visible", null));
    }

    @Test
    void testTopRightAsDescendentChild() {
        ToolBar[] toolBars = this.createTestToolBars("CTabFolder.special ToolBar { background: #FF0000}\nCTabFolder ToolBar { background: #00FF00}\nCTabFolder.extraordinary ToolBar { background: #FFFFFF}\nToolBar { background: #0000FF}");
        ToolBar barA = toolBars[0];
        ToolBar barB = toolBars[1];
        ToolBar barC = toolBars[2];
        WidgetElement.setCSSClass((Widget)barA.getParent(), (String)"special");
        this.engine.applyStyles((Object)barA.getShell(), true);
        Assertions.assertEquals((Object)RED, (Object)barA.getBackground().getRGB());
        Assertions.assertEquals((Object)GREEN, (Object)barB.getBackground().getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)barC.getBackground().getRGB());
        WidgetElement.setCSSClass((Widget)barA.getParent(), (String)"extraordinary");
        this.engine.applyStyles((Object)barA.getShell(), true);
        Assertions.assertEquals((Object)WHITE, (Object)barA.getBackground().getRGB());
    }

    @Test
    void testStyleLabelChildInCTabFolder() {
        Label labelToTest = this.createLabelInCTabFolder("Label { background-color: #0000FF; }\n");
        Assertions.assertEquals((Object)BLUE, (Object)labelToTest.getBackground().getRGB());
    }

    @Test
    void testSelectedImageVisible() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-selected-image-visible: true}");
        Assertions.assertEquals((Object)true, (Object)folderToTest.getSelectedImageVisible());
        Assertions.assertEquals((Object)"true", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-selected-image-visible", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-selected-image-visible: false}");
        Assertions.assertEquals((Object)false, (Object)folderToTest.getSelectedImageVisible());
        Assertions.assertEquals((Object)"false", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-selected-image-visible", null));
    }

    @Test
    void testMinimumCharacters() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabFolder { swt-tab-text-minimum-characters: 1}");
        Assertions.assertEquals((int)1, (int)folderToTest.getMinimumCharacters());
        Assertions.assertEquals((Object)"1", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-tab-text-minimum-characters", null));
        folderToTest = this.createTestCTabFolder("CTabFolder { swt-tab-text-minimum-characters: 1.2}");
        Assertions.assertEquals((int)1, (int)folderToTest.getMinimumCharacters());
        Assertions.assertEquals((Object)"1", (Object)this.engine.retrieveCSSProperty((Object)folderToTest, "swt-tab-text-minimum-characters", null));
    }
}

