/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.CTabItemElement;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class CTabItemTest
extends CSSSWTTestCase {
    private Shell shell;

    @Override
    @AfterEach
    public void tearDown() {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        super.tearDown();
    }

    private void spinEventLoop() {
        int i = 0;
        while (i < 3) {
            while (this.display.readAndDispatch()) {
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    private CTabFolder createFolder(Composite composite) {
        CTabFolder folderToTest = new CTabFolder(composite, 2048);
        int i = 0;
        while (i < 4) {
            CTabItem item = new CTabItem(folderToTest, 0);
            item.setText("Item " + i);
            Button control = new Button((Composite)folderToTest, 8);
            item.setControl((Control)control);
            ++i;
        }
        folderToTest.setSelection(0);
        return folderToTest;
    }

    private CTabFolder createTestTabFolder(boolean open) {
        this.shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        this.shell.setLayout((Layout)layout);
        CTabFolder folderToTest = this.createFolder((Composite)this.shell);
        if (open) {
            this.shell.open();
        }
        return folderToTest;
    }

    private CTabFolder createTestTabFolder(String styleSheet) {
        return this.createTestTabFolder(styleSheet, true);
    }

    protected CTabFolder createTestTabFolder(String styleSheet, boolean open) {
        CTabFolder folder = this.createTestTabFolder(open);
        this.engine = this.createEngine(styleSheet, folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        return folder;
    }

    @Test
    void testFontRegular() {
        CTabFolder folder = this.createTestTabFolder("Button { font-family: Verdana; font-size: 12 }\nCTabItem { font-family: Verdana; font-size: 16 }");
        this.spinEventLoop();
        folder.getItems();
        Assertions.assertEquals((int)0, (int)folder.getSelectionIndex());
        CTabItem item = folder.getItem(0);
        FontData fontData = item.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assertions.assertEquals((int)16, (int)fontData.getHeight());
        Assertions.assertEquals((int)0, (int)fontData.getStyle());
        Assertions.assertEquals((Object)"Verdana", (Object)this.engine.retrieveCSSProperty((Object)item, "font-family", null));
        Assertions.assertEquals((Object)"16", (Object)this.engine.retrieveCSSProperty((Object)item, "font-size", null));
        Control button = item.getControl();
        fontData = button.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assertions.assertEquals((int)12, (int)fontData.getHeight());
        Assertions.assertEquals((int)0, (int)fontData.getStyle());
    }

    @Test
    void testFontBold() {
        CTabFolder folder = this.createTestTabFolder("Button { font-weight: bold }\nCTabItem { font-weight: bold }");
        this.spinEventLoop();
        Assertions.assertEquals((int)0, (int)folder.getSelectionIndex());
        CTabItem item = folder.getItem(0);
        FontData fontData = item.getFont().getFontData()[0];
        Assertions.assertEquals((int)1, (int)fontData.getStyle());
        Assertions.assertEquals((Object)"bold", (Object)this.engine.retrieveCSSProperty((Object)item, "font-weight", null));
        Control button = item.getControl();
        fontData = button.getFont().getFontData()[0];
        Assertions.assertEquals((int)1, (int)fontData.getStyle());
    }

    @Test
    void testFontItalic() {
        CTabFolder folder = this.createTestTabFolder("Button { font-weight: bold }\nCTabItem { font-style: italic }");
        this.spinEventLoop();
        Assertions.assertEquals((int)0, (int)folder.getSelectionIndex());
        CTabItem item = folder.getItem(0);
        FontData fontData = item.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
        Assertions.assertEquals((Object)"italic", (Object)this.engine.retrieveCSSProperty((Object)item, "font-style", null));
        Control button = item.getControl();
        fontData = button.getFont().getFontData()[0];
        Assertions.assertEquals((int)1, (int)fontData.getStyle());
    }

    private void testSelectedFontBold(CTabFolder folder, int selectionIndex) {
        folder.setSelection(selectionIndex);
        this.spinEventLoop();
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            FontData fontData = items[i].getFont().getFontData()[0];
            if (i == selectionIndex) {
                Assertions.assertEquals((int)1, (int)fontData.getStyle());
            } else {
                Assertions.assertEquals((int)0, (int)fontData.getStyle());
            }
            ++i;
        }
    }

    @Test
    void testSelectedFontBold() {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        int i = 0;
        while (i < folder.getItemCount()) {
            this.testSelectedFontBold(folder, i);
            ++i;
        }
    }

    @Test
    void testSelectedFontMerged() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { font-weight: normal; font-style: italic }\nCTabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assertions.assertEquals((int)3, (int)fd.getStyle());
            } else {
                Assertions.assertEquals((int)2, (int)fd.getStyle());
            }
            ++n2;
        }
    }

    @Test
    void testSelectedFontMerged2() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { font-style: italic }\nCTabItem:selected { font-weight: bold }");
        this.spinEventLoop();
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assertions.assertEquals((int)3, (int)fd.getStyle());
            } else {
                Assertions.assertEquals((int)2, (int)fd.getStyle());
            }
            ++n2;
        }
    }

    @Test
    void testSelectedFontMerged3() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { font-weight: bold }\nCTabItem:selected { font-style: italic; font-weight: normal }");
        this.spinEventLoop();
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            FontData fd = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assertions.assertEquals((int)2, (int)fd.getStyle());
            } else {
                Assertions.assertEquals((int)1, (int)fd.getStyle());
            }
            ++n2;
        }
    }

    @Disabled(value="test was commented before bug 443094")
    @Test
    void testFontsEditorStackClass() {
        FontData data;
        CTabItem item;
        CTabFolder folder = this.createTestTabFolder(false);
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        WidgetElement.setCSSClass((Widget)folder2, (String)"editorStack");
        this.engine = this.createEngine("CTabItem { font-size: 10 }CTabItem:selected { font-size: 14; font-weight: bold }CTabFolder.editorStack CTabItem { font-size: 11; }CTabFolder.editorStack CTabItem:selected { font-size: 13; font-style: italic }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        Assertions.assertNotNull((Object)folder.getSelection());
        Assertions.assertNull((Object)folder2.getSelection());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            data = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assertions.assertEquals((int)14, (int)data.getHeight());
                Assertions.assertEquals((int)1, (int)data.getStyle());
            } else {
                Assertions.assertEquals((int)10, (int)data.getHeight());
                Assertions.assertEquals((int)0, (int)data.getStyle());
            }
            ++n2;
        }
        cTabItemArray = folder2.getItems();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            data = item.getFont().getFontData()[0];
            Assertions.assertEquals((int)11, (int)data.getHeight());
            Assertions.assertEquals((int)0, (int)data.getStyle());
            ++n2;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        cTabItemArray = folder2.getItems();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            data = item.getFont().getFontData()[0];
            if (item == folder2.getSelection()) {
                Assertions.assertEquals((int)13, (int)data.getHeight());
                Assertions.assertEquals((int)3, (int)data.getStyle());
            } else {
                Assertions.assertEquals((int)11, (int)data.getHeight());
                Assertions.assertEquals((int)0, (int)data.getStyle());
            }
            ++n2;
        }
    }

    @Disabled(value="test was commented before bug 443094")
    @Test
    void testFontsEditorStackClass2() {
        FontData data;
        CTabItem item;
        CTabFolder folder = this.createTestTabFolder(false);
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        WidgetElement.setCSSClass((Widget)folder2, (String)"editorStack");
        this.engine = this.createEngine("CTabItem { font-size: 10 }CTabItem:selected { font-size: 14; font-weight: bold }CTabFolder.editorStack CTabItem { font-size: 11; }CTabFolder.editorStack CTabItem:selected { font-size: 13; font-weight: normal; font-style: italic }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        Assertions.assertNotNull((Object)folder.getSelection());
        Assertions.assertNull((Object)folder2.getSelection());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            data = item.getFont().getFontData()[0];
            if (item == folder.getSelection()) {
                Assertions.assertEquals((int)14, (int)data.getHeight());
                Assertions.assertEquals((int)1, (int)data.getStyle());
            } else {
                Assertions.assertEquals((int)10, (int)data.getHeight());
                Assertions.assertEquals((int)0, (int)data.getStyle());
            }
            ++n2;
        }
        cTabItemArray = folder2.getItems();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            data = item.getFont().getFontData()[0];
            Assertions.assertEquals((int)11, (int)data.getHeight());
            Assertions.assertEquals((int)0, (int)data.getStyle());
            ++n2;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        cTabItemArray = folder2.getItems();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            data = item.getFont().getFontData()[0];
            if (item == folder2.getSelection()) {
                Assertions.assertEquals((int)13, (int)data.getHeight());
                Assertions.assertEquals((int)2, (int)data.getStyle());
            } else {
                Assertions.assertEquals((int)11, (int)data.getHeight());
                Assertions.assertEquals((int)0, (int)data.getStyle());
            }
            ++n2;
        }
    }

    @Disabled(value="test was commented before bug 443094")
    @Test
    void testShowCloseEditorStack() {
        CTabItem item;
        CTabFolder folder = this.createTestTabFolder(false);
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        WidgetElement.setCSSClass((Widget)folder2, (String)"editorStack");
        this.engine = this.createEngine("CTabItem { show-close: false }CTabItem:selected { show-close: true }CTabFolder.editorStack CTabItem { show-close: true }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        Assertions.assertNotNull((Object)folder.getSelection());
        Assertions.assertNull((Object)folder2.getSelection());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            if (item == folder.getSelection()) {
                Assertions.assertTrue((boolean)item.getShowClose());
            } else {
                Assertions.assertFalse((boolean)item.getShowClose());
            }
            ++n2;
        }
        cTabItemArray = folder2.getItems();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            Assertions.assertTrue((boolean)item.getShowClose());
            ++n2;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        cTabItemArray = folder2.getItems();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            Assertions.assertTrue((boolean)item.getShowClose());
            ++n2;
        }
    }

    @Disabled(value="test was commented before bug 443094")
    @Test
    void testShowCloseViewStack() {
        CTabItem item;
        CTabFolder folder = this.createTestTabFolder(false);
        CTabFolder folder2 = this.createFolder((Composite)folder.getShell());
        WidgetElement.setCSSClass((Widget)folder2, (String)"viewStack");
        this.engine = this.createEngine("CTabItem { show-close: false }CTabItem:selected { show-close: true }CTabFolder.viewStack CTabItem { show-close: false }CTabFolder.viewStack CTabItem.selected { show-close: true }", folder.getDisplay());
        this.engine.applyStyles((Object)folder.getShell(), true);
        folder.getShell().open();
        folder.setSelection(0);
        this.spinEventLoop();
        Assertions.assertNotNull((Object)folder.getSelection());
        Assertions.assertNull((Object)folder2.getSelection());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            if (item == folder.getSelection()) {
                Assertions.assertTrue((boolean)item.getShowClose());
            } else {
                Assertions.assertFalse((boolean)item.getShowClose());
            }
            ++n2;
        }
        cTabItemArray = folder2.getItems();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            item = cTabItemArray[n2];
            Assertions.assertFalse((boolean)item.getShowClose());
            ++n2;
        }
        folder2.setSelection(0);
        this.spinEventLoop();
        int i = 0;
        while (i < folder2.getItemCount()) {
            CTabItem item2 = folder.getItem(i);
            if (item2 == folder.getSelection()) {
                Assertions.assertTrue((boolean)item2.getShowClose());
            } else {
                Assertions.assertFalse((boolean)item2.getShowClose());
            }
            ++i;
        }
    }

    @Test
    void testBackground() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { background-color: #0000ff }", false);
        Assertions.assertEquals((Object)new RGB(0, 0, 255), (Object)folder.getBackground().getRGB());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Assertions.assertEquals((Object)"#0000ff", (Object)this.engine.retrieveCSSProperty((Object)item, "background-color", null));
            ++n2;
        }
    }

    @Test
    void testBackground2() {
        CTabFolder folder = this.createTestTabFolder(false);
        Color preStyledSelectionBackground = folder.getSelectionBackground();
        RGB rgb = new RGB(0, 0, 255);
        String colour = "#0000ff";
        if (rgb.equals((Object)preStyledSelectionBackground.getRGB())) {
            rgb = new RGB(0, 255, 0);
            colour = "#00ff00";
        }
        CSSEngine engine = this.createEngine("CTabItem { background-color: " + colour + " }", folder.getDisplay());
        engine.applyStyles((Object)folder, true);
        Assertions.assertEquals((Object)rgb, (Object)folder.getBackground().getRGB());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Assertions.assertEquals((Object)colour, (Object)engine.retrieveCSSProperty((Object)item, "background-color", null));
            ++n2;
        }
        Assertions.assertEquals((Object)preStyledSelectionBackground.getRGB(), (Object)folder.getSelectionBackground().getRGB());
    }

    @Test
    void testSelectionBackground() {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { background-color: #00ff00 }", false);
        Assertions.assertEquals((Object)new RGB(0, 255, 0), (Object)folder.getSelectionBackground().getRGB());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Assertions.assertEquals((Object)"#00ff00", (Object)this.engine.retrieveCSSProperty((Object)item, "background-color", "selected"));
            ++n2;
        }
    }

    @Test
    void testForeground() {
        CTabFolder folder = this.createTestTabFolder("CTabItem { color: #0000ff }", false);
        Assertions.assertEquals((Object)new RGB(0, 0, 255), (Object)folder.getForeground().getRGB());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Assertions.assertEquals((Object)"#0000ff", (Object)this.engine.retrieveCSSProperty((Object)item, "color", null));
            ++n2;
        }
    }

    @Test
    void testForeground2() {
        CTabFolder folder = this.createTestTabFolder(false);
        Color preStyledSelectionForeground = folder.getSelectionForeground();
        RGB rgb = new RGB(0, 0, 255);
        String colour = "#0000ff";
        if (rgb.equals((Object)preStyledSelectionForeground.getRGB())) {
            rgb = new RGB(0, 255, 0);
            colour = "#00ff00";
        }
        CSSEngine engine = this.createEngine("CTabItem { color: " + colour + " }", folder.getDisplay());
        engine.applyStyles((Object)folder, true);
        Assertions.assertEquals((Object)rgb, (Object)folder.getForeground().getRGB());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Assertions.assertEquals((Object)colour, (Object)engine.retrieveCSSProperty((Object)item, "color", null));
            ++n2;
        }
        Assertions.assertEquals((Object)preStyledSelectionForeground.getRGB(), (Object)folder.getSelectionForeground().getRGB());
    }

    @Test
    void testSelectionForeground() {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { color: #00ff00 }", false);
        Assertions.assertEquals((Object)new RGB(0, 255, 0), (Object)folder.getSelectionForeground().getRGB());
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Assertions.assertEquals((Object)"#00ff00", (Object)this.engine.retrieveCSSProperty((Object)item, "color", "selected"));
            ++n2;
        }
    }

    @Test
    void testParent() {
        CTabFolder folder = this.createTestTabFolder("CTabItem:selected { color: #00ff00 }", false);
        CTabItem[] cTabItemArray = folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            CTabItemElement element = (CTabItemElement)this.engine.getElement((Object)item);
            Assertions.assertNotNull((Object)element.getParentNode());
            ++n2;
        }
    }
}

