/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.util.Hashtable;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.osgi.framework.FrameworkUtil;

public class ColorDefinitionTest
extends CSSSWTTestCase {
    @Test
    void testColorDefinition() {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: green}", this.display);
        ColorDefinition definition = this.colorDefinition("ACTIVE_HYPERLINK_COLOR", "name", "categoryId", "description");
        Assertions.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        Assertions.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        Assertions.assertEquals((Object)new RGB(0, 128, 0), (Object)definition.getValue());
        Assertions.assertEquals((Object)"name", (Object)definition.getName());
        Assertions.assertEquals((Object)"categoryId", (Object)definition.getCategoryId());
        Assertions.assertTrue((boolean)definition.getDescription().startsWith("description"));
        Assertions.assertTrue((boolean)definition.isOverridden());
        engine.dispose();
    }

    @Test
    void testColorDefinitionWhenNameCategoryIdAndDescriptionOverridden() {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: green;label:'nameOverridden'; category:'#categoryIdOverridden'; description: 'descriptionOverridden'}", this.display);
        ColorDefinition definition = this.colorDefinition("ACTIVE_HYPERLINK_COLOR", "name", "categoryId", "description");
        Assertions.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        Assertions.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        Assertions.assertEquals((Object)new RGB(0, 128, 0), (Object)definition.getValue());
        Assertions.assertEquals((Object)"nameOverridden", (Object)definition.getName());
        Assertions.assertEquals((Object)"categoryIdOverridden", (Object)definition.getCategoryId());
        Assertions.assertTrue((boolean)definition.getDescription().startsWith("descriptionOverridden"));
        Assertions.assertTrue((boolean)definition.isOverridden());
        engine.dispose();
    }

    @Test
    void testColorDefinitionWhenDefinitionStylesheetNotFound() {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: green}", this.display);
        ColorDefinition definition = this.colorDefinition("color definition uniqueId without matching stylesheet", "name", "categoryId", "description");
        Assertions.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        Assertions.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        Assertions.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        Assertions.assertFalse((boolean)definition.isOverridden());
        engine.dispose();
    }

    @Test
    void testWidgetWithColorDefinitionAsBackgroundColor() {
        this.registerColorProviderWith("ACTIVE_HYPERLINK_COLOR", new RGB(255, 0, 0));
        CSSEngine engine = this.createEngine("Label {background-color: '#ACTIVE_HYPERLINK_COLOR'}", this.display);
        Shell shell = new Shell(this.display, 1264);
        Label label = new Label((Composite)shell, 0);
        label.setText("Some label text");
        engine.applyStyles((Object)label, true);
        Assertions.assertEquals((Object)new RGB(255, 0, 0), (Object)label.getBackground().getRGB());
        engine.dispose();
        shell.dispose();
    }

    @Test
    void testUnset() {
        CSSEngine engine = this.createEngine("Button {background-color: unset;}", this.display);
        Shell shell = new Shell(this.display, 1264);
        Button button = new Button((Composite)shell, 0);
        Color red = this.display.getSystemColor(3);
        button.setBackground(red);
        engine.applyStyles((Object)button, true);
        Assertions.assertNotEquals((Object)red.getRGB(), (Object)button.getBackground().getRGB());
        engine.dispose();
        shell.dispose();
    }

    @Test
    void testSetColorDefinitionWithSystemColor() {
        CSSEngine engine = this.createEngine("ColorDefinition#ACTIVE_HYPERLINK_COLOR{color: '#COLOR-LIST-SELECTION'}", this.display);
        ColorDefinition definition = this.colorDefinition("ACTIVE_HYPERLINK_COLOR", "name", "categoryId", "description");
        Assertions.assertEquals((Object)new RGB(0, 0, 0), (Object)definition.getValue());
        Assertions.assertFalse((boolean)definition.isOverridden());
        engine.applyStyles((Object)definition, true);
        Assertions.assertEquals((Object)this.display.getSystemColor(26).getRGB(), (Object)definition.getValue());
        Assertions.assertTrue((boolean)definition.isOverridden());
        engine.dispose();
    }

    private ColorDefinition colorDefinition(String uniqueId, String name, String categoryId, String description) {
        return new ColorDefinition(name, uniqueId, "defaultsTo", "black", categoryId, true, description, "pluginId");
    }

    private void registerColorProviderWith(String symbolicName, RGB rgb) {
        IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
        ((IColorAndFontProvider)Mockito.doReturn((Object)rgb).when((Object)provider)).getColor(symbolicName);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.ranking", "1000");
        FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(IColorAndFontProvider.class, (Object)provider, properties);
    }
}

