/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescendentTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB WHITE = new RGB(255, 255, 255);
    static final RGB BLACK = new RGB(0, 0, 0);

    protected Button[] createTestWidgets(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panelA = new Composite((Composite)shell, 0);
        panelA.setLayout((Layout)new FillLayout());
        Composite panelB = new Composite((Composite)shell, 0);
        panelB.setLayout((Layout)new FillLayout());
        Button buttonA = new Button(panelA, 0);
        Button buttonB = new Button(panelB, 0);
        Button buttonC = new Button((Composite)shell, 0);
        this.engine.applyStyles((Object)shell, true);
        return new Button[]{buttonA, buttonB, buttonC};
    }

    @Test
    void testDescendentSpecificity() {
        Button[] buttons = this.createTestWidgets("Composite.special Button { background: #FF0000}\nComposite Button { background: #00FF00}\nComposite.extraordinary Button { background: #FFFFFF}\n#parent Button { background: #000000}\nButton { background: #0000FF}");
        Button buttonA = buttons[0];
        Button buttonB = buttons[1];
        Button buttonC = buttons[2];
        WidgetElement.setCSSClass((Widget)buttonA.getParent(), (String)"special");
        this.engine.applyStyles((Object)buttonA.getShell(), true);
        Assertions.assertEquals((Object)RED, (Object)buttonA.getBackground().getRGB());
        Assertions.assertEquals((Object)GREEN, (Object)buttonB.getBackground().getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)buttonC.getBackground().getRGB());
        WidgetElement.setCSSClass((Widget)buttonA.getParent(), (String)"extraordinary");
        WidgetElement.setID((Widget)buttonB.getParent(), (String)"parent");
        this.engine.applyStyles((Object)buttonA.getShell(), true);
        Assertions.assertEquals((Object)WHITE, (Object)buttonA.getBackground().getRGB());
        Assertions.assertEquals((Object)BLACK, (Object)buttonB.getBackground().getRGB());
    }
}

