/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.util.Hashtable;
import org.eclipse.e4.ui.internal.css.swt.definition.IColorAndFontProvider;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.osgi.framework.FrameworkUtil;

public class FontDefinitionTest
extends CSSSWTTestCase {
    @Test
    void testFontDefinition() {
        this.engine = this.createEngine("FontDefinition#org-eclipse-jface-bannerfont {font-family: 'Times';font-size: 12;font-style: italic;font-weight: bold;}", this.display);
        FontDefinition definition = this.fontDefinition("org.eclipse.jface.bannerfont", "name", "categoryId", "description");
        Assertions.assertNull((Object)definition.getValue());
        Assertions.assertFalse((boolean)definition.isOverridden());
        this.engine.applyStyles((Object)definition, true);
        Assertions.assertNotNull((Object)definition.getValue());
        Assertions.assertEquals((Object)"Times", (Object)definition.getValue()[0].getName());
        Assertions.assertEquals((int)12, (int)definition.getValue()[0].getHeight());
        Assertions.assertEquals((int)3, (int)definition.getValue()[0].getStyle());
        Assertions.assertEquals((Object)"categoryId", (Object)definition.getCategoryId());
        Assertions.assertEquals((Object)"name", (Object)definition.getName());
        Assertions.assertTrue((boolean)definition.getDescription().startsWith("description"));
        Assertions.assertTrue((boolean)definition.isOverridden());
    }

    @Test
    void testFontDefinitionWhenNameCategoryIdAndDescriptionOverridden() {
        this.engine = this.createEngine("FontDefinition#org-eclipse-jface-bannerfont {font-family: 'Times';font-size: 12;font-style: italic; font-weight: bold; label:'nameOverridden'; category: '#categoryIdOverridden'; description: 'descriptionOverridden'}", this.display);
        FontDefinition definition = this.fontDefinition("org.eclipse.jface.bannerfont", "name", "categoryId", "description");
        Assertions.assertNull((Object)definition.getValue());
        Assertions.assertFalse((boolean)definition.isOverridden());
        this.engine.applyStyles((Object)definition, true);
        Assertions.assertNotNull((Object)definition.getValue());
        Assertions.assertEquals((Object)"Times", (Object)definition.getValue()[0].getName());
        Assertions.assertEquals((int)12, (int)definition.getValue()[0].getHeight());
        Assertions.assertEquals((int)3, (int)definition.getValue()[0].getStyle());
        Assertions.assertEquals((Object)"categoryIdOverridden", (Object)definition.getCategoryId());
        Assertions.assertEquals((Object)"nameOverridden", (Object)definition.getName());
        Assertions.assertTrue((boolean)definition.getDescription().startsWith("descriptionOverridden"));
        Assertions.assertTrue((boolean)definition.isOverridden());
    }

    @Test
    void testFontDefinitionWhenDefinitionStylesheetNotFound() {
        this.engine = this.createEngine("FontDefinition#org-eclipse-jface-bannerfont {font-family: 'Times';font-size: 12;font-style: italic;}", this.display);
        FontDefinition definition = this.fontDefinition("font definition uniqueId without matching stylesheet", "name", "categoryId", "description");
        Assertions.assertNull((Object)definition.getValue());
        Assertions.assertFalse((boolean)definition.isOverridden());
        this.engine.applyStyles((Object)definition, true);
        Assertions.assertNull((Object)definition.getValue());
        Assertions.assertFalse((boolean)definition.isOverridden());
    }

    @Test
    void testWidgetWithFontDefinitionAsFontFamily() {
        this.registerFontProviderWith("org.eclipse.jface.bannerfont", new FontData("Times", 12, 2));
        this.engine = this.createEngine("Label {font-family: '#org-eclipse-jface-bannerfont'}", this.display);
        Shell shell = new Shell(this.display, 1264);
        Label label = new Label((Composite)shell, 0);
        Font font = new Font((Device)this.display, "Arial", 9, 1);
        label.setFont(font);
        label.setText("Some label text");
        this.engine.applyStyles((Object)label, true);
        Assertions.assertEquals((Object)"Times", (Object)label.getFont().getFontData()[0].getName());
        Assertions.assertEquals((int)12, (int)label.getFont().getFontData()[0].getHeight());
        Assertions.assertEquals((int)3, (int)label.getFont().getFontData()[0].getStyle());
        shell.dispose();
        font.dispose();
    }

    private FontDefinition fontDefinition(String uniqueId, String name, String categoryId, String description) {
        return new FontDefinition(new FontDefinition(name, uniqueId, "defaultsId", "value", categoryId, true, description), new FontData[]{new FontData("Arial", 10, 0)});
    }

    private void registerFontProviderWith(String symbolicName, FontData fontData) {
        IColorAndFontProvider provider = (IColorAndFontProvider)Mockito.mock(IColorAndFontProvider.class);
        ((IColorAndFontProvider)Mockito.doReturn((Object)new FontData[]{fontData}).when((Object)provider)).getFont(symbolicName);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.ranking", "1000");
        FrameworkUtil.getBundle(this.getClass()).getBundleContext().registerService(IColorAndFontProvider.class, (Object)provider, null);
    }
}

