/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.lang.reflect.Field;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GradientTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);
    static final RGB WHITE = new RGB(255, 255, 255);

    protected CTabFolder createTestCTabFolder(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        CTabFolder folderToTest = new CTabFolder(panel, 0);
        CTabItem tab1 = new CTabItem(folderToTest, 0);
        tab1.setText("A TAB ITEM");
        this.engine.applyStyles((Object)folderToTest, true);
        shell.pack();
        return folderToTest;
    }

    @Test
    void testGradients() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #0000FF}");
        Assertions.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
    }

    @Test
    void testDefaultPercents() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #0000FF}");
        Assertions.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        Assertions.assertArrayEquals((int[])new int[]{100}, (int[])this.getSelectionGradientPercents(folderToTest));
    }

    @Test
    void testDefaultManyPercents() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: red green blue yellow}");
        Assertions.assertArrayEquals((int[])new int[]{33, 67, 100}, (int[])this.getSelectionGradientPercents(folderToTest));
    }

    @Test
    void testSpecifiedPercents() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #0000FF 53%}");
        Assertions.assertArrayEquals((int[])new int[]{53}, (int[])this.getSelectionGradientPercents(folderToTest));
    }

    @Test
    void testManyColorsAndSpecifiedManyPercents() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #00FF00 #0000FF 22% 44%}");
        Assertions.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        Assertions.assertEquals((Object)GREEN, (Object)this.getSelectionBackground(folderToTest, 1).getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        Assertions.assertArrayEquals((int[])new int[]{22, 44}, (int[])this.getSelectionGradientPercents(folderToTest));
    }

    @Test
    void testBadPercents() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: red green blue yellow 10%}");
        Assertions.assertArrayEquals((int[])new int[]{33, 67, 100}, (int[])this.getSelectionGradientPercents(folderToTest));
    }

    @Test
    void testBadColors() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 notAColor #0000FF}");
        Assertions.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        Assertions.assertArrayEquals((int[])new int[]{100}, (int[])this.getSelectionGradientPercents(folderToTest));
    }

    @Test
    void testAboveRangePercents() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #00FF00 #0000FF 20% 110%}");
        Assertions.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        Assertions.assertArrayEquals((int[])new int[]{50, 100}, (int[])this.getSelectionGradientPercents(folderToTest));
    }

    @Test
    void testBelowRangePercents() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: #FF0000 #00FF00 #0000FF -20% 50%}");
        Assertions.assertEquals((Object)RED, (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)folderToTest.getSelectionBackground().getRGB());
        Assertions.assertArrayEquals((int[])new int[]{50, 100}, (int[])this.getSelectionGradientPercents(folderToTest));
    }

    @Test
    void testAltSyntax() {
        CTabFolder folderToTest = this.createTestCTabFolder("CTabItem:selected { background-color: gradient, rgb(140,140,140), rgb(48,48,48), 100%;");
        Assertions.assertEquals((Object)new RGB(140, 140, 140), (Object)this.getSelectionBackgroundBegin(folderToTest).getRGB());
        Assertions.assertEquals((Object)new RGB(48, 48, 48), (Object)folderToTest.getSelectionBackground().getRGB());
        Assertions.assertArrayEquals((int[])new int[]{100}, (int[])this.getSelectionGradientPercents(folderToTest));
    }

    Color getSelectionBackgroundBegin(CTabFolder folder) {
        return this.getSelectionBackground(folder, 0);
    }

    Color getSelectionBackground(CTabFolder folder, int i) {
        try {
            Field field = folder.getClass().getDeclaredField("selectionGradientColors");
            field.setAccessible(true);
            return ((Color[])field.get(folder))[i];
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    int[] getSelectionGradientPercents(CTabFolder folder) {
        try {
            Field field = folder.getClass().getDeclaredField("selectionGradientPercents");
            field.setAccessible(true);
            return (int[])field.get(folder);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }
}

