/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Label;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LabelTest
extends CSSSWTTestCase {
    @Test
    void testColor() {
        Label labelToTest = this.createTestLabel("Label { background-color: #FF0000; color: #0000FF }");
        Assertions.assertEquals((Object)RED, (Object)labelToTest.getBackground().getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)labelToTest.getForeground().getRGB());
    }

    @Test
    void testFontRegular() {
        Label labelToTest = this.createTestLabel("Label { font: Verdana 16px }");
        Assertions.assertEquals((int)1, (int)labelToTest.getFont().getFontData().length);
        FontData fontData = labelToTest.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assertions.assertEquals((int)16, (int)fontData.getHeight());
        Assertions.assertEquals((int)0, (int)fontData.getStyle());
    }

    @Test
    void testFontBold() {
        Label labelToTest = this.createTestLabel("Label { font: Arial 12px; font-weight: bold }");
        Assertions.assertEquals((int)1, (int)labelToTest.getFont().getFontData().length);
        FontData fontData = labelToTest.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assertions.assertEquals((int)12, (int)fontData.getHeight());
        Assertions.assertEquals((int)1, (int)fontData.getStyle());
    }

    @Test
    void testFontItalic() {
        Label labelToTest = this.createTestLabel("Label { font-style: italic }");
        Assertions.assertEquals((int)1, (int)labelToTest.getFont().getFontData().length);
        FontData fontData = labelToTest.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
    }

    @Test
    void testAlignment() {
        Label labelToTest = this.createTestLabel("Label { swt-alignment: right }");
        Assertions.assertEquals((int)131072, (int)labelToTest.getAlignment());
        labelToTest = this.createTestLabel("Label { swt-alignment: center; }");
        Assertions.assertEquals((int)0x1000000, (int)labelToTest.getAlignment());
        labelToTest = this.createTestLabel("Label { swt-alignment: left; }");
        Assertions.assertEquals((int)16384, (int)labelToTest.getAlignment());
    }

    @Test
    void testAlignment2() {
        Label labelToTest = this.createTestLabel("Label { swt-alignment: trail }");
        Assertions.assertEquals((int)131072, (int)labelToTest.getAlignment());
        labelToTest = this.createTestLabel("Label { swt-alignment: lead; }");
        Assertions.assertEquals((int)16384, (int)labelToTest.getAlignment());
    }
}

