/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.util.HashSet;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShellTest
extends CSSSWTTestCase {
    static final RGB RED = new RGB(255, 0, 0);
    static final RGB GREEN = new RGB(0, 255, 0);
    static final RGB BLUE = new RGB(0, 0, 255);

    protected Shell createTestShell(String styleSheet) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        this.engine.applyStyles((Object)shell, true);
        shell.pack();
        return shell;
    }

    @Test
    void testColor() {
        Shell shellToTest = this.createTestShell("Shell { background-color: #FF0000; color: #0000FF }");
        Assertions.assertEquals((Object)RED, (Object)shellToTest.getBackground().getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)shellToTest.getForeground().getRGB());
    }

    @Test
    void testFontRegular() {
        Shell shellToTest = this.createTestShell("Shell { font: Verdana 16px }");
        Assertions.assertEquals((int)1, (int)shellToTest.getFont().getFontData().length);
        FontData fontData = shellToTest.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Verdana", (Object)fontData.getName());
        Assertions.assertEquals((int)16, (int)fontData.getHeight());
        Assertions.assertEquals((int)0, (int)fontData.getStyle());
    }

    @Test
    void testFontBold() {
        Shell shellToTest = this.createTestShell("Shell { font: Arial 12px; font-weight: bold }");
        Assertions.assertEquals((int)1, (int)shellToTest.getFont().getFontData().length);
        FontData fontData = shellToTest.getFont().getFontData()[0];
        Assertions.assertEquals((Object)"Arial", (Object)fontData.getName());
        Assertions.assertEquals((int)12, (int)fontData.getHeight());
        Assertions.assertEquals((int)1, (int)fontData.getStyle());
    }

    @Test
    void testFontItalic() {
        Shell shellToTest = this.createTestShell("Shell { font-style: italic }");
        Assertions.assertEquals((int)1, (int)shellToTest.getFont().getFontData().length);
        FontData fontData = shellToTest.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
    }

    @Test
    void test375069ChildShellDifferentiation() {
        this.engine = this.createEngine("Shell.parent { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assertions.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
        Assertions.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assertions.assertNotSame((Object)2, (Object)fontData.getStyle());
    }

    @Test
    void test375069AllShell() {
        this.engine = this.createEngine("Shell { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assertions.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
        Assertions.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
    }

    @Test
    void testShellParentage() {
        this.engine = this.createEngine("Shell[parentage='parent'] { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setID((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setID((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assertions.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assertions.assertNotSame((Object)2, (Object)fontData.getStyle());
        Assertions.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
    }

    @Test
    void testShellUnparentedPseudoelement() {
        this.engine = this.createEngine("Shell:swt-unparented { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assertions.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
        Assertions.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assertions.assertNotSame((Object)2, (Object)fontData.getStyle());
    }

    @Test
    void testShellParentedPseudoelement() {
        this.engine = this.createEngine("Shell:swt-parented { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        WidgetElement.setCSSClass((Widget)parent, (String)"parent");
        Shell child = new Shell(parent, 0);
        WidgetElement.setCSSClass((Widget)child, (String)"child");
        parent.open();
        child.open();
        this.engine.applyStyles((Object)parent, true);
        this.engine.applyStyles((Object)child, true);
        Assertions.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assertions.assertNotSame((Object)2, (Object)fontData.getStyle());
        Assertions.assertEquals((int)1, (int)child.getFont().getFontData().length);
        fontData = child.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
    }

    @Test
    void testSwtDataClassAttribute() {
        this.engine = this.createEngine("Shell[swt-data-class ~= 'java.util.HashSet'] { font-style: italic; }", this.display);
        Shell parent = new Shell(this.display, 0);
        parent.setData(new HashSet());
        parent.open();
        this.engine.applyStyles((Object)parent, true);
        Assertions.assertEquals((int)1, (int)parent.getFont().getFontData().length);
        FontData fontData = parent.getFont().getFontData()[0];
        Assertions.assertEquals((int)2, (int)fontData.getStyle());
    }

    @Test
    void testBackgroundMode() {
        Shell shellToTest = this.createTestShell("Shell { swt-background-mode: force; }");
        Assertions.assertEquals((int)2, (int)shellToTest.getBackgroundMode());
    }
}

