/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.css.swt.helpers.PropertyHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPropertyHelper {
    @Test
    void testReadWriteProperty() throws Exception {
        Impl bean = new Impl();
        Assertions.assertEquals((Object)"A", (Object)PropertyHelper.getProperty((Object)bean, (String)"a"));
        Assertions.assertEquals((Object)"B", (Object)PropertyHelper.getProperty((Object)bean, (String)"b"));
    }

    @Test
    void testReadOnlyProperty() throws Exception {
        Impl bean = new Impl();
        Assertions.assertEquals((Object)"C", (Object)PropertyHelper.getProperty((Object)bean, (String)"c"));
        Assertions.assertEquals((Object)true, (Object)PropertyHelper.getProperty((Object)bean, (String)"d"));
    }

    @Test
    void testNestedProperty() throws Exception {
        Impl bean = new Impl();
        Assertions.assertEquals((Object)"Nested", (Object)PropertyHelper.getProperty((Object)bean, (String)"nested.a"));
    }

    public static class Base {
        private String a = "A";

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public String getC() {
            return "C";
        }

        public boolean isD() {
            return true;
        }
    }

    public static class Impl
    extends Base {
        private String b = "B";
        private Base nested = new Base();

        public Impl() {
            this.nested.a = "Nested";
        }

        public String getB() {
            return this.b;
        }

        public void setB(String b) {
            this.b = b;
        }

        public Base getNested() {
            return this.nested;
        }

        public void setNested(Base nested) {
            this.nested = nested;
        }
    }
}

