/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.e4.ui.css.swt.internal.theme.Theme;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.widgets.Display;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;

public class ThemeTest
extends CSSSWTTestCase {
    private BundleContext context;
    private ServiceRegistration<EventHandler> themeListenerRegistration;
    private ServiceReference<IThemeManager> themeManagerReference;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Bundle b = FrameworkUtil.getBundle(this.getClass());
        Assertions.assertNotNull((Object)b, (String)"Not running in an OSGi environment");
        this.context = b.getBundleContext();
        Assertions.assertNotNull((Object)b, (String)"Not running in an OSGi environment");
        this.themeManagerReference = this.context.getServiceReference(IThemeManager.class);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.themeListenerRegistration.unregister();
        super.tearDown();
    }

    @Test
    void testThemeChangeNotification() {
        Display display = Display.getDefault();
        IThemeEngine themer = this.getThemeEngine(display);
        boolean[] success = new boolean[1];
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("event.topics", "org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged");
        this.themeListenerRegistration = this.context.registerService(EventHandler.class, event -> {
            ITheme theme = (ITheme)event.getProperty("theme");
            blArray[0] = "org/eclipse/e4/ui/css/swt/theme/ThemeManager/themeChanged".equals(event.getTopic()) && theme != null && theme.getId().equals("test") && event.getProperty("device") == display && event.getProperty("themeEngine") == themer && event.getProperty("restore") == Boolean.TRUE;
        }, properties);
        Assertions.assertFalse((boolean)success[0]);
        themer.setTheme((ITheme)new Theme("test", "Test"), true);
        Assertions.assertTrue((boolean)success[0]);
    }

    private IThemeEngine getThemeEngine(Display display) {
        IThemeManager manager = (IThemeManager)this.context.getService(this.themeManagerReference);
        Assertions.assertNotNull((Object)manager, (String)"Theme manager service not available");
        return manager.getEngineForDisplay(display);
    }
}

