/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.swt;

import org.eclipse.e4.ui.tests.css.swt.CSSSWTTestCase;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ToolItemTest
extends CSSSWTTestCase {
    protected ToolItem createTestToolItem(String styleSheet, int styleBit) {
        this.engine = this.createEngine(styleSheet, this.display);
        Shell shell = new Shell(this.display, 1264);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new FillLayout());
        ToolBar toolBar = new ToolBar(panel, 0x800000);
        ToolItem toolItemToTest = new ToolItem(toolBar, styleBit);
        toolItemToTest.setText("Some text");
        this.engine.applyStyles((Object)toolItemToTest, true);
        shell.pack();
        return toolItemToTest;
    }

    @Test
    void testBackgroundColor() {
        ToolItem toolItemToTest = this.createTestToolItem("ToolItem { background-color: #FF0000;}", 8);
        Assertions.assertEquals((Object)RED, (Object)toolItemToTest.getBackground().getRGB());
    }

    @Test
    void testForegroundColor() {
        ToolItem toolItemToTest = this.createTestToolItem("ToolItem { color: #FF0000;}", 8);
        Assertions.assertEquals((Object)RED, (Object)toolItemToTest.getForeground().getRGB());
    }

    @Test
    @Disabled(value="Not yet implemented")
    void testSelectedPseudo() {
        ToolItem toolItemToTest = this.createTestToolItem("ToolItem { color: #FF0000; }\nToolItem:checked { color: #0000FF; }", 8);
        Assertions.assertEquals((Object)RED, (Object)toolItemToTest.getForeground().getRGB());
        toolItemToTest.setSelection(true);
        this.engine.applyStyles((Object)toolItemToTest, false);
        Assertions.assertEquals((Object)BLUE, (Object)toolItemToTest.getForeground().getRGB());
    }

    @Test
    void ensurePseudoAttributeAllowsToSelectionPushButton() {
        ToolItem toolItemToTest = this.createTestToolItem("ToolItem[style~='SWT.CHECK'] { background-color: #FF0000; color: #0000FF }", 32);
        Assertions.assertEquals((Object)RED, (Object)toolItemToTest.getBackground().getRGB());
        Assertions.assertEquals((Object)BLUE, (Object)toolItemToTest.getForeground().getRGB());
        ToolItem unStyledBToolItem = this.createTestToolItem("ToolItem[style~='SWT.PUSH'] { background-color: #FF0000; color: #0000FF }", 32);
        Assertions.assertNotEquals((Object)RED, (Object)unStyledBToolItem.getBackground().getRGB());
        Assertions.assertNotEquals((Object)BLUE, (Object)unStyledBToolItem.getForeground().getRGB());
    }
}

