/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.internal.persistence.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.internal.persistence.IWorkbenchState;
import org.eclipse.e4.tools.persistence.PerspectivePersister;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.Selector;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityView;

public final class CommonUtil {
    public static String MEMENTO_KEY = "memento";
    public static String EDITOR_AREA = "org.eclipse.ui.editorss";

    private CommonUtil() {
    }

    public static IEclipseContext getEclipseContext() {
        return Workbench.getInstance().getContext();
    }

    public static EModelService getEModelService() {
        return (EModelService)CommonUtil.getEclipseContext().get(EModelService.class);
    }

    public static MWindow getCurrentMainWindow() {
        MApplication mApplication = (MApplication)CommonUtil.getEclipseContext().get(MApplication.class);
        List children = mApplication.getChildren();
        MWindow mWindow = (MWindow)children.get(0);
        return mWindow;
    }

    public static void persistCompatibilityEditors(MUIElement root) {
        CommonUtil.getEModelService().findElements(root, "org.eclipse.e4.ui.compatibility.editor", MPart.class).forEach(CommonUtil::persistCompatibilityEditor);
    }

    private static void persistCompatibilityEditor(MPart part) {
        if (part.getObject() instanceof CompatibilityEditor) {
            CompatibilityEditor editor = (CompatibilityEditor)part.getObject();
            EditorReference reference = (EditorReference)editor.getReference();
            try {
                Method persistMethod = reference.getClass().getDeclaredMethod("persist", new Class[0]);
                persistMethod.setAccessible(true);
                persistMethod.invoke((Object)reference, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot call EditorReference's persist method", e);
            }
        }
    }

    public static List<MPart> getPerspectivePartsWithState(MPerspective perspective) {
        List phList = CommonUtil.getEModelService().findElements((MUIElement)perspective, null, MPlaceholder.class, null);
        ArrayList<MPart> result = new ArrayList<MPart>();
        for (MPlaceholder ph : phList) {
            MUIElement element = ph.getRef();
            if (!MPart.class.isInstance(element)) continue;
            MPart part = (MPart)MPart.class.cast(element);
            CommonUtil.persist(part);
            result.add(part);
        }
        return result;
    }

    private static void persist(MPart part) {
        Optional<IViewPart> viewPart = CommonUtil.getOptionalViewPart(part);
        if (viewPart.isPresent()) {
            XMLMemento root = XMLMemento.createWriteRoot((String)"view");
            viewPart.get().saveState((IMemento)root);
            StringWriter writer = new StringWriter();
            try {
                root.save((Writer)writer);
                part.getPersistedState().put(MEMENTO_KEY, writer.toString());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static Optional<IViewPart> getOptionalViewPart(MPart part) {
        if (!CompatibilityView.class.isInstance(part.getObject())) {
            return Optional.empty();
        }
        CompatibilityView cv = (CompatibilityView)CompatibilityView.class.cast(part.getObject());
        if (cv == null) {
            return Optional.empty();
        }
        IViewPart viewPart = cv.getView();
        return Optional.ofNullable(viewPart);
    }

    public static MSnippetContainer createSnippetContainer() {
        return new MSnippetContainer(){
            private final List<MUIElement> list = new ArrayList<MUIElement>();

            public List<MUIElement> getSnippets() {
                return this.list;
            }
        };
    }

    public static EPartService getEPartService() {
        return (EPartService)CommonUtil.getEclipseContext().get(EPartService.class);
    }

    public static MPerspective getMainPerspectiveFromWindow(MWindow window, final String perspectiveId) {
        List findElements = CommonUtil.getEModelService().findElements((MApplicationElement)window, MPerspective.class, 29, new Selector(){

            public boolean select(MApplicationElement element) {
                return Objects.equals(element.getElementId(), perspectiveId);
            }
        });
        if (findElements == null || findElements.isEmpty()) {
            throw new IllegalStateException("No perspective found with id " + perspectiveId);
        }
        if (findElements.size() > 1) {
            throw new IllegalStateException("Too many perspectives found");
        }
        return (MPerspective)findElements.get(0);
    }

    public static IWorkbenchState createWorkbenchState(MWindow window, MPerspective perspective) {
        if (window == null) {
            throw new NullPointerException("Window must not be null");
        }
        IWorkbenchState workbenchState = PerspectivePersister.convertPerspective(perspective);
        if (window instanceof MTrimmedWindow) {
            MTrimmedWindow tw = (MTrimmedWindow)window;
            tw.getTrimBars().stream().filter(CommonUtil::isSideBar).map(t -> (MTrimBar)CommonUtil.getEModelService().cloneElement((MUIElement)t, null)).forEach(arg_0 -> workbenchState.getTrimBars().add(arg_0));
        }
        return workbenchState;
    }

    public static Optional<IEditorPart> getOptionalEditorPart(MPart part) {
        if (!CompatibilityEditor.class.isInstance(part.getObject())) {
            return Optional.empty();
        }
        CompatibilityEditor ce = (CompatibilityEditor)CompatibilityEditor.class.cast(part.getObject());
        if (ce == null) {
            return Optional.empty();
        }
        IEditorPart editorPart = ce.getEditor();
        return Optional.ofNullable(editorPart);
    }

    public static boolean isSideBar(MTrimBar trimBar) {
        return trimBar.getSide() == SideValue.LEFT || trimBar.getSide() == SideValue.RIGHT;
    }
}

