/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.e4.tools.internal.persistence.IPartMemento;
import org.eclipse.e4.tools.internal.persistence.IPersistenceFactory;
import org.eclipse.e4.tools.internal.persistence.IWorkbenchState;
import org.eclipse.e4.tools.internal.persistence.util.CommonUtil;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStackIdHelper;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class PerspectivePersister {
    private PerspectivePersister() {
    }

    public static String serializePerspectiveAndPartStates(String perspectiveId) {
        MWindow mWindow = CommonUtil.getCurrentMainWindow();
        MPerspective perspective = CommonUtil.getMainPerspectiveFromWindow(mWindow, perspectiveId);
        IWorkbenchState workbenchState = CommonUtil.createWorkbenchState(mWindow, perspective);
        String xml = PerspectivePersister.serialize(workbenchState);
        return xml;
    }

    private static String serialize(EObject eObject) {
        EObject copy = EcoreUtil.copy((EObject)eObject);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)"virtualUri"));
        resource.getContents().add((Object)copy);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (StringWriter writer = new StringWriter();){
                URIConverter.WriteableOutputStream uws = new URIConverter.WriteableOutputStream((Writer)writer, "UTF-8");
                resource.save((OutputStream)uws, null);
                String xml = ((Object)writer).toString().trim();
                ((Writer)writer).close();
                return xml;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void restoreWorkbenchState(String serializedState) {
        IWorkbenchState toBeMerged = PerspectivePersister.deserialize(serializedState);
        PerspectivePersister.restoreWorkbenchState(toBeMerged);
    }

    public static void restoreWorkbenchState(IWorkbenchState workbenchState) {
        MWindow currentWindow = CommonUtil.getCurrentMainWindow();
        EPartService ePartService = CommonUtil.getEPartService();
        PerspectivePersister.disposeCurrentParts(ePartService.getParts());
        MPerspective perspective = workbenchState.getPerspective();
        ePartService.switchPerspective(perspective.getElementId());
        Shell widget = (Shell)currentWindow.getWidget();
        widget.setRedraw(false);
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ArrayList<IViewPart> viewPartsToHide = new ArrayList<IViewPart>();
            ArrayList<IViewReference> viewReferencesToHide = new ArrayList<IViewReference>();
            ArrayList<MPart> parts = new ArrayList<MPart>();
            for (IPartMemento viewSetting : workbenchState.getViewSettings()) {
                List elements = CommonUtil.getEModelService().findElements((MUIElement)currentWindow, viewSetting.getPartId(), MPart.class, null);
                if (elements.size() < 1) {
                    System.err.println("Part ID has not been found. View Settings cannot be restored for part: " + viewSetting.getPartId());
                    continue;
                }
                MPart part = (MPart)elements.get(0);
                parts.add(part);
                Optional<IViewPart> viewPart = CommonUtil.getOptionalViewPart(part);
                if (viewPart.isPresent()) {
                    viewPartsToHide.add(viewPart.get());
                    continue;
                }
                IViewReference viewRef = (IViewReference)part.getTransientData().get(IWorkbenchPartReference.class.getName());
                if (viewRef == null) continue;
                IViewReference resolved = activePage.findViewReference(viewRef.getId());
                if (resolved == null) {
                    try {
                        IViewPart view = activePage.showView(viewRef.getId());
                        if (view == null) continue;
                        viewPartsToHide.add(view);
                    }
                    catch (PartInitException e) {
                        System.err.println("Failed to initialize part");
                        e.printStackTrace();
                    }
                    continue;
                }
                viewReferencesToHide.add(resolved);
            }
            viewReferencesToHide.forEach(arg_0 -> ((IWorkbenchPage)activePage).hideView(arg_0));
            viewPartsToHide.forEach(arg_0 -> ((IWorkbenchPage)activePage).hideView(arg_0));
            for (MPart p : parts) {
                Image image;
                if (p.getIconURI() == null || (image = JFaceResources.getImageRegistry().get(p.getIconURI())) == null || !image.isDisposed()) continue;
                JFaceResources.getImageRegistry().remove(p.getIconURI());
            }
            for (IPartMemento viewSetting : workbenchState.getViewSettings()) {
                List elements = CommonUtil.getEModelService().findElements((MUIElement)currentWindow, viewSetting.getPartId(), MPart.class, null);
                if (elements.size() < 1) {
                    System.err.println("Part ID has not been found. View Settings cannot be restored for part: " + viewSetting.getPartId());
                    continue;
                }
                MPart part = (MPart)elements.get(0);
                parts.add(part);
                part.getPersistedState().put(CommonUtil.MEMENTO_KEY, viewSetting.getMemento());
            }
            PerspectivePersister.replaceExistingPerspective(currentWindow, workbenchState.getPerspective(), workbenchState.getPerspective().getElementId());
            if (workbenchState.getEditorArea() != null) {
                PerspectivePersister.replaceEditorAreaContents(currentWindow, workbenchState.getEditorArea());
            }
            if (currentWindow instanceof MTrimmedWindow) {
                PerspectivePersister.replaceSideTrimBars((MTrimmedWindow)currentWindow, workbenchState.getTrimBars());
            }
            MPerspective appliedPerspective = CommonUtil.getMainPerspectiveFromWindow(currentWindow, workbenchState.getPerspective().getElementId());
            List stacks = CommonUtil.getEModelService().findElements((MUIElement)appliedPerspective, null, MPartStack.class);
            stacks.stream().filter(s -> s.getTags().contains("Minimized")).forEach(s -> {
                s.getTags().remove("Minimized");
                s.getTags().add("Minimized");
            });
        }
        finally {
            widget.setRedraw(true);
        }
    }

    private static void disposeCurrentParts(Collection<MPart> parts) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        LinkedList viewPartsToHide = new LinkedList();
        LinkedList editorsToHide = new LinkedList();
        parts.forEach(part -> {
            Optional<IViewPart> viewPart = CommonUtil.getOptionalViewPart(part);
            if (viewPart.isPresent()) {
                viewPartsToHide.add(viewPart.get());
                return;
            }
            Optional<IEditorPart> editorPart = CommonUtil.getOptionalEditorPart(part);
            if (editorPart.isPresent()) {
                editorsToHide.add(editorPart.get());
                return;
            }
            CommonUtil.getEPartService().hidePart(part);
        });
        viewPartsToHide.forEach(arg_0 -> ((IWorkbenchPage)activePage).hideView(arg_0));
        editorsToHide.forEach(e -> {
            boolean bl = activePage.closeEditor(e, true);
        });
    }

    private static void replaceSideTrimBars(MTrimmedWindow window, List<MTrimBar> trimBars) {
        for (MTrimBar trimBar : trimBars) {
            if (!CommonUtil.isSideBar(trimBar)) continue;
            MTrimBar clonedTrimBar = (MTrimBar)CommonUtil.getEModelService().cloneElement((MUIElement)trimBar, null);
            SideValue side = trimBar.getSide();
            Optional<MTrimBar> existingTrimOptional = window.getTrimBars().stream().filter(t -> t.getSide() == side).findFirst();
            if (existingTrimOptional.isPresent()) {
                MTrimBar existingTrim = existingTrimOptional.get();
                LinkedList children = new LinkedList(existingTrim.getChildren());
                children.forEach(arg_0 -> ((EModelService)CommonUtil.getEModelService()).deleteModelElement(arg_0));
                List trimElementsToAdd = clonedTrimBar.getChildren().stream().filter(te -> PerspectivePersister.isTrimPartOfPerspective(te, window)).collect(Collectors.toList());
                existingTrim.getChildren().addAll(trimElementsToAdd);
                existingTrim.getTags().clear();
                existingTrim.getTags().addAll(trimBar.getTags());
                existingTrim.setVisible(trimBar.isVisible());
                existingTrim.setToBeRendered(trimBar.isToBeRendered());
                continue;
            }
            window.getTrimBars().add(clonedTrimBar);
        }
    }

    private static boolean isTrimPartOfPerspective(MTrimElement te, MTrimmedWindow window) {
        EModelService eModelService = CommonUtil.getEModelService();
        MPerspective activePerspective = eModelService.getActivePerspective((MWindow)window);
        Map parsedIds = TrimStackIdHelper.parseTrimStackId((String)te.getElementId());
        String stackId = (String)parsedIds.get(TrimStackIdHelper.TrimStackIdPart.ELEMENT_ID);
        MUIElement foundElement = eModelService.find(stackId, (MUIElement)activePerspective);
        return foundElement != null;
    }

    private static IWorkbenchState deserialize(String serializedState) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)"virtualUri"));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (StringReader reader = new StringReader(serializedState);){
                URIConverter.ReadableInputStream is = new URIConverter.ReadableInputStream((Reader)reader, "UTF-8");
                resource.load((InputStream)is, null);
                EObject eObject = (EObject)resource.getContents().get(0);
                if (!(eObject instanceof IWorkbenchState)) {
                    throw new IllegalStateException("Corrupted Perspective File");
                }
                return (IWorkbenchState)eObject;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void replaceExistingPerspective(MWindow currentWindow, MPerspective toBeMerged, String perspectiveName) {
        MPerspective currentPerspective = CommonUtil.getMainPerspectiveFromWindow(currentWindow, perspectiveName);
        Control control = (Control)currentPerspective.getWidget();
        MUIElement editorArea = CommonUtil.getEModelService().find(CommonUtil.EDITOR_AREA, (MUIElement)currentPerspective);
        if (editorArea != null) {
            editorArea.setToBeRendered(false);
        }
        MPerspectiveStack mPerspectiveStack = (MPerspectiveStack)PerspectivePersister.deletePerspective(currentPerspective);
        control.dispose();
        MPerspective clonedPerspective = PerspectivePersister.addPerspective(toBeMerged, mPerspectiveStack, currentWindow);
        MUIElement activeElement = PerspectivePersister.getActiveElement(clonedPerspective);
        EPartService ePartService = CommonUtil.getEPartService();
        ePartService.switchPerspective(clonedPerspective);
        if (activeElement instanceof MPart) {
            ePartService.activate((MPart)activeElement, true);
        }
    }

    private static void replaceEditorAreaContents(MWindow currentWindow, MArea toBeMerged) {
        List editorAreaList = CommonUtil.getEModelService().findElements((MUIElement)currentWindow, CommonUtil.EDITOR_AREA, MArea.class, null, 9);
        MSnippetContainer snippetContainer = CommonUtil.createSnippetContainer();
        snippetContainer.getSnippets().add(toBeMerged);
        MArea cloneSnippet = (MArea)CommonUtil.getEModelService().cloneSnippet(snippetContainer, toBeMerged.getElementId(), currentWindow);
        MArea editorArea = (MArea)editorAreaList.get(0);
        while (editorArea.getChildren().size() > 0) {
            Object widget = ((MPartSashContainerElement)editorArea.getChildren().get(0)).getWidget();
            EcoreUtil.delete((EObject)((EObject)editorArea.getChildren().get(0)));
            if (!(widget instanceof Control)) continue;
            ((Control)widget).dispose();
        }
        editorArea.getChildren().addAll(cloneSnippet.getChildren());
        PerspectivePersister.activateEditors(editorArea);
    }

    private static void activateEditors(MArea editorArea) {
        EPartService partService = CommonUtil.getEPartService();
        List partStacks = CommonUtil.getEModelService().findElements((MUIElement)editorArea, null, MPartStack.class);
        LinkedHashMap<MPartStack, MStackElement> stackSelections = new LinkedHashMap<MPartStack, MStackElement>();
        for (MPartStack partStack : partStacks) {
            stackSelections.put(partStack, (MStackElement)partStack.getSelectedElement());
        }
        List editorParts = CommonUtil.getEModelService().findElements((MUIElement)editorArea, null, MPart.class);
        for (MPart editor : editorParts) {
            partService.activate(editor, false);
        }
        for (MPartStack partStack : stackSelections.keySet()) {
            partStack.setSelectedElement((MUIElement)((MStackElement)stackSelections.get(partStack)));
        }
    }

    private static MUIElement getActiveElement(MPerspective clonedPerspective) {
        MPerspective activeElement = clonedPerspective;
        while (activeElement instanceof MElementContainer) {
            MUIElement selectedElement = ((MElementContainer)activeElement).getSelectedElement();
            if (selectedElement == null) break;
            activeElement = selectedElement;
        }
        if (activeElement instanceof MPlaceholder) {
            activeElement = ((MPlaceholder)activeElement).getRef();
        }
        return activeElement;
    }

    private static EObject deletePerspective(MPerspective currentPerspective) {
        EObject eContainer = ((EObject)currentPerspective).eContainer();
        EcoreUtil.delete((EObject)((EObject)currentPerspective));
        return eContainer;
    }

    private static MPerspective addPerspective(MPerspective perspective2BeMerged, MPerspectiveStack mPerspectiveStack, MWindow currentWindow) {
        MSnippetContainer snippetContainer = CommonUtil.createSnippetContainer();
        snippetContainer.getSnippets().add(perspective2BeMerged);
        MUIElement cloneSnippet = CommonUtil.getEModelService().cloneSnippet(snippetContainer, perspective2BeMerged.getElementId(), currentWindow);
        mPerspectiveStack.getChildren().add((MPerspective)cloneSnippet);
        return (MPerspective)cloneSnippet;
    }

    public static IWorkbenchState convertPerspective(MPerspective perspective) {
        MSnippetContainer snippetContainer = CommonUtil.createSnippetContainer();
        CommonUtil.persistCompatibilityEditors((MUIElement)perspective);
        CommonUtil.getEModelService().cloneElement((MUIElement)perspective, snippetContainer);
        IWorkbenchState workbenchState = IPersistenceFactory.eINSTANCE.createWorkbenchState();
        workbenchState.setPerspective((MPerspective)snippetContainer.getSnippets().get(0));
        List<MPart> parts = CommonUtil.getPerspectivePartsWithState(perspective);
        for (MPart part : parts) {
            IPartMemento partMemento = IPersistenceFactory.eINSTANCE.createPartMemento();
            partMemento.setPartId(part.getElementId());
            partMemento.setMemento((String)part.getPersistedState().get(CommonUtil.MEMENTO_KEY));
            workbenchState.getViewSettings().add((Object)partMemento);
        }
        MPlaceholder editorAreaPlaceholder = (MPlaceholder)CommonUtil.getEModelService().find(CommonUtil.EDITOR_AREA, (MUIElement)perspective);
        if (editorAreaPlaceholder != null) {
            MArea editorArea = (MArea)editorAreaPlaceholder.getRef();
            CommonUtil.persistCompatibilityEditors((MUIElement)editorArea);
            MArea clonedEditorArea = (MArea)CommonUtil.getEModelService().cloneElement((MUIElement)editorArea, null);
            workbenchState.setEditorArea(clonedEditorArea);
        }
        return workbenchState;
    }
}

