/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.launcher;

import org.eclipse.swt.examples.launcher.ItemDescriptor;

class ItemTreeNode {
    private ItemTreeNode nextSibling;
    private ItemTreeNode firstChild;
    private ItemDescriptor descriptor;

    public ItemTreeNode(ItemDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void addSortedNode(ItemTreeNode node) {
        if (this.firstChild == null) {
            this.firstChild = node;
        } else if (this.firstChild.descriptor.getName().compareTo(node.descriptor.getName()) > 0) {
            node.nextSibling = this.firstChild;
            this.firstChild = node;
        } else {
            ItemTreeNode cursor = this.firstChild;
            while (cursor.nextSibling != null) {
                ItemTreeNode sibling = cursor.nextSibling;
                if (sibling.descriptor.getName().compareTo(node.descriptor.getName()) > 0) break;
                cursor = cursor.nextSibling;
            }
            node.nextSibling = cursor.nextSibling;
            cursor.nextSibling = node;
        }
    }

    public ItemDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ItemTreeNode getNextSibling() {
        return this.nextSibling;
    }

    public ItemTreeNode getFirstChild() {
        return this.firstChild;
    }
}

