/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.examples.dotproject;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;

public class HighlightStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
CaretListener,
IEclipsePreferences.IPreferenceChangeListener {
    private static final String ANNOTATION_TYPE = "org.eclipse.ui.genericeditor.text";
    public static final String TOGGLE_HIGHLIGHT_PREFERENCE = "org.eclipse.ui.genericeditor.togglehighlight";
    public static final String GENERIC_EDITOR_BUNDLE_ID = "org.eclipse.ui.genericeditor";
    private boolean enabled;
    private ISourceViewer sourceViewer;
    private IDocument document;
    private static final String TAG_NAME_REGEX = "<\\/?\\s*([a-zA-Z]+)";
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("<\\/?\\s*([a-zA-Z]+)");
    private Annotation[] fOccurrenceAnnotations = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHighlights(int offset) {
        if (this.sourceViewer == null || !this.enabled) {
            return;
        }
        String text = this.document.get();
        offset = ((ITextViewerExtension5)this.sourceViewer).widgetOffset2ModelOffset(offset);
        int wordStartOffset = Math.max(text.lastIndexOf(47, offset), text.lastIndexOf(60, offset)) + 1;
        int wordEndOffset = HighlightStrategy.findEndingOffset(text, offset);
        if (wordEndOffset <= wordStartOffset || wordEndOffset == -1 || wordStartOffset == -1) {
            return;
        }
        String word = text.substring(wordStartOffset, wordEndOffset);
        if (word.indexOf(62) != -1 || word.indexOf(60) != -1) {
            this.removeOccurrenceAnnotations();
            return;
        }
        Matcher m = TAG_NAME_PATTERN.matcher(text);
        HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>();
        while (m.find()) {
            if (!m.group(1).equals(word)) continue;
            annotationMap.put(new Annotation(ANNOTATION_TYPE, false, null), new Position(m.start(1), m.end(1) - m.start(1)));
        }
        if (annotationMap.size() < 2) {
            this.removeOccurrenceAnnotations();
            return;
        }
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        Object object = HighlightStrategy.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, annotationMap);
            } else {
                this.removeOccurrenceAnnotations();
                for (Map.Entry mapEntry : annotationMap.entrySet()) {
                    annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                }
            }
            this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.size()]);
        }
    }

    private static int findEndingOffset(String text, int offset) {
        String substring = text.substring(offset);
        String[] split = substring.split("[^a-zA-Z0-9]+");
        if (split.length == 0) {
            return -1;
        }
        return offset + split[0].length();
    }

    public void install(ITextViewer viewer) {
        if (!(viewer instanceof ISourceViewer)) {
            return;
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(GENERIC_EDITOR_BUNDLE_ID);
        preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.enabled = preferences.getBoolean(TOGGLE_HIGHLIGHT_PREFERENCE, true);
        this.sourceViewer = (ISourceViewer)viewer;
        this.sourceViewer.getTextWidget().addCaretListener((CaretListener)this);
    }

    public void uninstall() {
        if (this.sourceViewer != null) {
            this.sourceViewer.getTextWidget().removeCaretListener((CaretListener)this);
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(GENERIC_EDITOR_BUNDLE_ID);
        preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(TOGGLE_HIGHLIGHT_PREFERENCE)) {
            this.enabled = Boolean.parseBoolean(event.getNewValue().toString());
            if (this.enabled) {
                this.initialReconcile();
            } else {
                this.removeOccurrenceAnnotations();
            }
        }
    }

    public void caretMoved(CaretEvent event) {
        this.applyHighlights(event.caretOffset);
    }

    public void initialReconcile() {
        if (this.sourceViewer != null) {
            this.sourceViewer.getTextWidget().getDisplay().asyncExec(() -> {
                if (this.sourceViewer != null && this.sourceViewer.getTextWidget() != null) {
                    this.applyHighlights(this.sourceViewer.getTextWidget().getCaretOffset());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = HighlightStrategy.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                Annotation[] annotationArray = this.fOccurrenceAnnotations;
                int n = this.fOccurrenceAnnotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation fOccurrenceAnnotation = annotationArray[n2];
                    annotationModel.removeAnnotation(fOccurrenceAnnotation);
                    ++n2;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private static Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }
}

