/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.examples.dotproject;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class NaturesAndProjectsContentAssistProcessor
implements IContentAssistProcessor {
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String text = viewer.getDocument().get();
        String natureTag = "<nature>";
        String projectReferenceTag = "<project>";
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        int natureTagLength = natureTag.length();
        if (text.length() >= natureTagLength && offset >= natureTagLength && text.substring(offset - natureTagLength, offset).equals(natureTag)) {
            IProjectNatureDescriptor[] natureDescriptors = workspace.getNatureDescriptors();
            ICompletionProposal[] proposals = new ICompletionProposal[natureDescriptors.length];
            int i = 0;
            while (i < natureDescriptors.length) {
                IProjectNatureDescriptor descriptor = natureDescriptors[i];
                proposals[i] = new CompletionProposal(descriptor.getNatureId(), offset, 0, descriptor.getNatureId().length());
                ++i;
            }
            return proposals;
        }
        int projectReferenceTagLength = projectReferenceTag.length();
        if (text.length() >= projectReferenceTagLength && offset >= projectReferenceTagLength && text.substring(offset - projectReferenceTagLength, offset).equals(projectReferenceTag)) {
            IProject[] projects = workspace.getRoot().getProjects();
            ICompletionProposal[] proposals = new ICompletionProposal[projects.length];
            int i = 0;
            while (i < projects.length) {
                proposals[i] = new CompletionProposal(projects[i].getName(), offset, 0, projects[i].getName().length());
                ++i;
            }
            return proposals;
        }
        return new ICompletionProposal[0];
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

