/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.examples.dotproject;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class SpellCheckDocumentListener
implements IDocumentListener {
    Job lastJob = null;
    SpellingService service = EditorsUI.getSpellingService();

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(final DocumentEvent event) {
        if (this.lastJob != null) {
            this.lastJob.cancel();
        }
        this.lastJob = new Job("Spellcheck"){

            protected IStatus run(IProgressMonitor monitor) {
                ITextFileBuffer iTextFileBuffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(event.getDocument());
                if (iTextFileBuffer == null) {
                    return Status.CANCEL_STATUS;
                }
                final IAnnotationModel model = iTextFileBuffer.getAnnotationModel();
                String text = event.getDocument().get();
                int commentStart = text.indexOf("<comment>");
                if (commentStart < 0) {
                    return Status.OK_STATUS;
                }
                int commentEnd = text.indexOf("</comment>", commentStart += "<comment>".length());
                if (commentEnd <= commentStart) {
                    return Status.OK_STATUS;
                }
                Region region = new Region(commentStart, commentEnd - commentStart);
                SpellCheckDocumentListener.this.service.check(event.getDocument(), (IRegion[])new Region[]{region}, new SpellingContext(), new ISpellingProblemCollector(){
                    private final Map<SpellingAnnotation, Position> annotations = new HashMap<SpellingAnnotation, Position>();

                    public void endCollecting() {
                        HashSet previous = new HashSet();
                        model.getAnnotationIterator().forEachRemaining(annotation -> {
                            if (annotation instanceof SpellingAnnotation) {
                                previous.add((SpellingAnnotation)annotation);
                            }
                        });
                        if (model instanceof IAnnotationModelExtension) {
                            ((IAnnotationModelExtension)model).replaceAnnotations((Annotation[])previous.toArray(new SpellingAnnotation[previous.size()]), this.annotations);
                        } else {
                            previous.forEach(arg_0 -> ((IAnnotationModel)model).removeAnnotation(arg_0));
                            this.annotations.forEach((arg_0, arg_1) -> ((IAnnotationModel)model).addAnnotation(arg_0, arg_1));
                        }
                    }

                    public void beginCollecting() {
                    }

                    public void accept(SpellingProblem problem) {
                        this.annotations.put(new SpellingAnnotation(problem), new Position(problem.getOffset(), problem.getLength()));
                    }
                }, monitor);
                return Status.OK_STATUS;
            }
        };
        this.lastJob.setUser(false);
        this.lastJob.setPriority(50);
        this.lastJob.schedule(500L);
    }
}

