/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.examples.dotproject.codemining;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.ui.genericeditor.examples.dotproject.codemining.ProjectReferenceCodeMining;

public class ProjectReferencesCodeMiningProvider
extends AbstractCodeMiningProvider {
    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.supplyAsync(() -> {
            IDocument document = viewer.getDocument();
            ArrayList<ProjectReferenceCodeMining> minings = new ArrayList<ProjectReferenceCodeMining>();
            int lineCount = document.getNumberOfLines();
            int i = 0;
            while (i < lineCount) {
                monitor.isCanceled();
                String line = ProjectReferencesCodeMiningProvider.getLineText(document, i).trim();
                int startIndex = line.indexOf("<name>");
                if (startIndex != -1) {
                    String projectName;
                    int endIndex = line.indexOf("</name>");
                    if (endIndex <= (startIndex += "<name>".length()) || (projectName = line.substring(startIndex, endIndex)).isEmpty()) break;
                    try {
                        minings.add(new ProjectReferenceCodeMining(projectName, i, document, (ICodeMiningProvider)this));
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++i;
            }
            return minings;
        });
    }

    private static String getLineText(IDocument document, int line) {
        try {
            int lo = document.getLineOffset(line);
            int ll = document.getLineLength(line);
            return document.get(lo, ll);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

