/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class CallHistory {
    private final List<String> methodList = new ArrayList<String>();
    private final Class<? extends Object> classType;

    public CallHistory(Object target) {
        this.classType = target.getClass();
    }

    private void testMethodName(String methodName) {
        Method[] methods;
        Method[] methodArray = methods = this.classType.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Target class (" + this.classType.getName() + ") does not contain method: " + methodName);
    }

    public void add(String methodName) {
        this.testMethodName(methodName);
        this.methodList.add(methodName);
    }

    public void clear() {
        this.methodList.clear();
    }

    public boolean verifyOrder(String[] testNames) throws IllegalArgumentException {
        int testIndex = 0;
        int testLength = testNames.length;
        if (testLength == 0) {
            return true;
        }
        for (String methodName : this.methodList) {
            String testName = testNames[testIndex];
            this.testMethodName(testName);
            if (testName.equals(methodName)) {
                ++testIndex;
            }
            if (testIndex < testLength) continue;
            return true;
        }
        return false;
    }

    public String[] verifyAndReturnOrder(String[] testNames) throws IllegalArgumentException {
        if (this.verifyOrder(testNames)) {
            return testNames;
        }
        return this.methodList.toArray(new String[0]);
    }

    public boolean contains(String methodName) {
        this.testMethodName(methodName);
        return this.methodList.contains(methodName);
    }

    public boolean contains(String[] methodNames) {
        String[] stringArray = methodNames;
        int n = methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            this.testMethodName(methodName);
            if (!this.methodList.contains(methodName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.methodList.isEmpty();
    }

    public void printToConsole() {
        for (String methodName : this.methodList) {
            System.out.println(methodName);
        }
    }
}

