/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.harness.util.TestRunLogUtil;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class CloseTestWindowsRule
extends ExternalResource {
    private String testName;
    private final List<IWorkbenchWindow> testWindows = new ArrayList<IWorkbenchWindow>(3);
    private TestWindowListener windowListener;
    private Set<Shell> initialShells;
    private boolean leakChecksDisabled;

    public Statement apply(Statement base, Description description) {
        this.testName = description.getDisplayName();
        return super.apply(base, description);
    }

    protected void before() throws Exception {
        this.addWindowListener();
        this.storeInitialShells();
        CloseTestWindowsRule.trace(TestRunLogUtil.formatTestStartMessage(this.testName));
    }

    protected void after() {
        CloseTestWindowsRule.trace(TestRunLogUtil.formatTestFinishedMessage(this.testName));
        this.removeWindowListener();
        UITestUtil.processEvents();
        this.closeAllTestWindows();
        UITestUtil.processEvents();
        this.checkForLeakedShells();
    }

    private static void trace(String msg) {
        System.out.println(msg);
    }

    private void addWindowListener() {
        this.windowListener = new TestWindowListener();
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.windowListener);
    }

    private void removeWindowListener() {
        if (this.windowListener != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.windowListener);
        }
    }

    private void closeAllTestWindows() {
        ArrayList<IWorkbenchWindow> testWindowsCopy = new ArrayList<IWorkbenchWindow>(this.testWindows);
        for (IWorkbenchWindow testWindow : testWindowsCopy) {
            testWindow.close();
        }
        this.testWindows.clear();
    }

    private void storeInitialShells() {
        this.initialShells = Set.of(PlatformUI.getWorkbench().getDisplay().getShells());
    }

    private void checkForLeakedShells() {
        Shell[] shells;
        ArrayList<String> leakedModalShellTitles = new ArrayList<String>();
        Shell[] shellArray = shells = PlatformUI.getWorkbench().getDisplay().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (!shell.isDisposed() && !this.initialShells.contains(shell)) {
                leakedModalShellTitles.add(shell.getText());
                shell.close();
            }
            ++n2;
        }
        if (!this.leakChecksDisabled) {
            Assert.assertEquals((String)("Test leaked modal shell: [" + String.join((CharSequence)", ", leakedModalShellTitles) + "]"), (long)0L, (long)leakedModalShellTitles.size());
        }
    }

    public void disableLeakChecks() {
        this.leakChecksDisabled = true;
    }

    void setTestName(String testName) {
        this.testName = testName;
    }

    private class TestWindowListener
    implements IWindowListener {
        private TestWindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            CloseTestWindowsRule.this.testWindows.remove(window);
        }

        public void windowOpened(IWorkbenchWindow window) {
            CloseTestWindowsRule.this.testWindows.add(window);
        }
    }
}

