/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.tests.internal.util.VerifyDialog;
import org.junit.Assert;

public class DialogCheck {
    private static VerifyDialog _verifyDialog;

    private DialogCheck() {
    }

    public static void assertDialog(Dialog dialog) {
        Assert.assertNotNull((Object)dialog);
        if (_verifyDialog.getShell() == null) {
            DialogCheck.getShell();
        }
        if (_verifyDialog.open(dialog) == 3) {
            Assert.fail((String)_verifyDialog.getFailureText());
        }
    }

    public static void assertDialogTexts(Dialog dialog) {
        Assert.assertNotNull((Object)dialog);
        dialog.setBlockOnOpen(false);
        dialog.open();
        Shell shell = dialog.getShell();
        UITestUtil.processEvents();
        try {
            DialogCheck.verifyCompositeText((Composite)shell);
        }
        finally {
            dialog.close();
            _verifyDialog.buttonPressed(2);
        }
    }

    public static Shell getShell() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        _verifyDialog = new VerifyDialog(shell);
        _verifyDialog.create();
        return _verifyDialog.getShell();
    }

    private static void verifyCompositeText(Composite composite) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof TabFolder) {
                TabFolder folder = (TabFolder)child;
                int numPages = folder.getItemCount();
                int j = 0;
                while (j < numPages) {
                    folder.setSelection(j);
                    ++j;
                }
            } else if (child instanceof CTabFolder) {
                CTabFolder folder = (CTabFolder)child;
                int numPages = folder.getItemCount();
                int j = 0;
                while (j < numPages) {
                    folder.setSelection(j);
                    ++j;
                }
            } else if (child instanceof Button) {
                Button b = (Button)child;
                DialogCheck.verifyButtonText(b);
            } else if (child instanceof Label) {
                Label l = (Label)child;
                DialogCheck.verifyLabelText(l);
            } else if (child instanceof Composite) {
                Composite comp = (Composite)child;
                DialogCheck.verifyCompositeText(comp);
            }
            ++n2;
        }
    }

    private static void verifyButtonText(Button button) {
        String widget = button.toString();
        Point size = button.getSize();
        Point preferred = button.computeSize(-1, -1);
        if (preferred.y * size.y > 0) {
            String buttonText = button.getText();
            preferred.y = (int)((long)preferred.y / (buttonText.isEmpty() ? 1L : buttonText.lines().count()));
            if (size.y / preferred.y > 1) {
                preferred.x /= size.y / preferred.y;
            }
        }
        String message = "Warning: " + widget + "\n\tActual Width -> " + size.x + "\n\tRecommended Width -> " + preferred.x;
        if (preferred.x > size.x) {
            button.getShell().dispose();
            Assert.fail((String)message);
        }
    }

    private static void verifyLabelText(Label label) {
        if (!label.isVisible()) {
            return;
        }
        String widget = label.toString();
        Point size = label.getSize();
        String labelText = label.getText();
        if (labelText == null || labelText.isEmpty()) {
            return;
        }
        Point preferred = label.computeSize(-1, -1);
        if (preferred.y * size.y > 0) {
            preferred.y = (int)((long)preferred.y / label.getText().lines().count());
            if (size.y / preferred.y > 1) {
                preferred.x /= size.y / preferred.y;
            }
        }
        String message = "Warning: " + widget + "\n\tActual Width -> " + size.x + "\n\tRecommended Width -> " + preferred.x;
        if (preferred.x > size.x) {
            label.getShell().dispose();
            Assert.fail((String)message);
        }
    }
}

