/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.tests.harness.util.DisplayHelper;

public class EditorTestHelper {
    public static final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String COMPILATION_UNIT_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    public static final String RESOURCE_PERSPECTIVE_ID = "org.eclipse.ui.resourcePerspective";
    public static final String JAVA_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";
    public static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    public static final String PACKAGE_EXPLORER_VIEW_ID = "org.eclipse.jdt.ui.PackageExplorer";
    public static final String INTRO_VIEW_ID = "org.eclipse.ui.internal.introview";

    public static void closeEditor(IEditorPart editor) {
        IWorkbenchPage page;
        IWorkbenchPartSite site;
        if (editor != null && (site = editor.getSite()) != null && (page = site.getPage()) != null) {
            page.closeEditor(editor, false);
        }
    }

    public static void closeAllEditors() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference[] editorReferences;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                int n5 = editorReferences.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    EditorTestHelper.closeEditor(editorReference.getEditor(false));
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void runEventQueue() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        if (window != null) {
            EditorTestHelper.runEventQueue(window.getShell());
        }
    }

    public static void runEventQueue(IWorkbenchPart part) {
        EditorTestHelper.runEventQueue(part.getSite().getShell());
    }

    public static void runEventQueue(Shell shell) {
        EditorTestHelper.runEventQueue(shell.getDisplay());
    }

    public static void runEventQueue(Display display) {
        while (display.readAndDispatch()) {
        }
    }

    public static void runEventQueue(long millis) {
        EditorTestHelper.runEventQueue(EditorTestHelper.getActiveDisplay(), millis);
    }

    public static void runEventQueue(IWorkbenchPart part, long millis) {
        EditorTestHelper.runEventQueue(part.getSite().getShell(), millis);
    }

    public static void runEventQueue(Shell shell, long millis) {
        EditorTestHelper.runEventQueue(shell.getDisplay(), millis);
    }

    public static void runEventQueue(Display display, long minTime) {
        if (display != null) {
            DisplayHelper.sleep(display, minTime);
        } else {
            EditorTestHelper.sleep((int)minTime);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static void forceFocus() {
        Shell shell;
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] wbWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (wbWindows.length == 0) {
                return;
            }
            window = wbWindows[0];
        }
        if ((shell = window.getShell()) != null && !shell.isDisposed()) {
            shell.forceActive();
            shell.forceFocus();
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        return window != null ? window.getActivePage() : null;
    }

    public static Display getActiveDisplay() {
        IWorkbenchWindow window = EditorTestHelper.getActiveWorkbenchWindow();
        return window != null ? window.getShell().getDisplay() : null;
    }

    public static void joinBackgroundActivities() {
        boolean interrupted = true;
        while (interrupted) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                interrupted = false;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        EditorTestHelper.joinJobs(0L, 0L, 500L);
    }

    public static boolean joinJobs(long minTime, long maxTime, long intervalTime) {
        EditorTestHelper.runEventQueue(minTime);
        DisplayHelper helper = new DisplayHelper(){

            @Override
            public boolean condition() {
                return EditorTestHelper.allJobsQuiet();
            }
        };
        return helper.waitForCondition(EditorTestHelper.getActiveDisplay(), maxTime > 0L ? maxTime : Long.MAX_VALUE, intervalTime);
    }

    public static void sleep(int intervalTime) {
        try {
            Thread.sleep(intervalTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean allJobsQuiet() {
        Job[] jobs;
        IJobManager jobManager = Job.getJobManager();
        Job[] jobArray = jobs = jobManager.find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            int state = job.getState();
            if (state == 4 || state == 2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isViewShown(String viewId) {
        return EditorTestHelper.getActivePage().findViewReference(viewId) != null;
    }

    public static boolean showView(String viewId, boolean show) throws PartInitException {
        boolean shown;
        IWorkbenchPage activePage = EditorTestHelper.getActivePage();
        IViewReference view = activePage.findViewReference(viewId);
        boolean bl = shown = view != null;
        if (shown != show) {
            if (show) {
                activePage.showView(viewId);
            } else {
                activePage.hideView(view);
            }
        }
        return shown;
    }

    public static void bringToTop() {
        EditorTestHelper.getActiveWorkbenchWindow().getShell().forceActive();
    }

    public static String showPerspective(String perspective) throws WorkbenchException {
        String shownPerspective = EditorTestHelper.getActivePage().getPerspective().getId();
        if (!perspective.equals(shownPerspective)) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
            workbench.showPerspective(perspective, activeWindow);
        }
        return shownPerspective;
    }

    public static IFile[] findFiles(IResource resource) throws CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        EditorTestHelper.findFiles(resource, files);
        return files.toArray(new IFile[files.size()]);
    }

    private static void findFiles(IResource resource, List<IFile> files) throws CoreException {
        if (resource instanceof IFile) {
            files.add((IFile)resource);
            return;
        }
        if (resource instanceof IContainer) {
            IResource[] resources;
            IResource[] iResourceArray = resources = ((IContainer)resource).members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resourceItem = iResourceArray[n2];
                EditorTestHelper.findFiles(resourceItem, files);
                ++n2;
            }
        }
    }
}

