/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.tests.harness.util.EditorTestHelper;
import org.junit.Assert;

public class SWTEventHelper {
    private static Event fgKeyCodeEvent = new Event();
    private static Event fgKeyCharEvent = new Event();
    private static Event fgMouseMoveEvent = new Event();
    private static Event fgMouseButtonEvent = new Event();
    private static boolean _dragDetected;

    public static void pressKeyCode(Display display, int keyCode) {
        SWTEventHelper.pressKeyCode(display, keyCode, true);
    }

    public static void pressKeyCode(Display display, int keyCode, boolean runEventQueue) {
        SWTEventHelper.keyCodeDown(display, keyCode, runEventQueue);
        SWTEventHelper.keyCodeUp(display, keyCode, runEventQueue);
    }

    public static void pressKeyCodeCombination(Display display, int[] keyCodes) {
        SWTEventHelper.pressKeyCodeCombination(display, keyCodes, true);
    }

    public static void pressKeyCodeCombination(Display display, int[] keyCodes, boolean runEventQueue) {
        int[] nArray = keyCodes;
        int n = keyCodes.length;
        int n2 = 0;
        while (n2 < n) {
            int keyCode = nArray[n2];
            SWTEventHelper.keyCodeDown(display, keyCode, runEventQueue);
            ++n2;
        }
        int i = keyCodes.length - 1;
        while (i >= 0) {
            SWTEventHelper.keyCodeUp(display, keyCodes[i], runEventQueue);
            --i;
        }
    }

    public static void keyCodeDown(Display display, int keyCode) {
        SWTEventHelper.keyCodeEvent(display, 1, keyCode, true);
    }

    public static void keyCodeDown(Display display, int keyCode, boolean runEventQueue) {
        SWTEventHelper.keyCodeEvent(display, 1, keyCode, runEventQueue);
    }

    public static void keyCodeUp(Display display, int keyCode) {
        SWTEventHelper.keyCodeEvent(display, 2, keyCode, true);
    }

    public static void keyCodeUp(Display display, int keyCode, boolean runEventQueue) {
        SWTEventHelper.keyCodeEvent(display, 2, keyCode, runEventQueue);
    }

    public static void keyCodeEvent(Display display, int type, int keyCode, boolean runEventQueue) {
        SWTEventHelper.fgKeyCodeEvent.type = type;
        SWTEventHelper.fgKeyCodeEvent.keyCode = keyCode;
        SWTEventHelper.postEvent(display, fgKeyCodeEvent, runEventQueue);
    }

    public static void pressKeyChar(Display display, char keyChar) {
        SWTEventHelper.pressKeyChar(display, keyChar, true);
    }

    public static void pressKeyChar(Display display, char keyChar, boolean runEventQueue) {
        SWTEventHelper.keyCharDown(display, keyChar, runEventQueue);
        SWTEventHelper.keyCharUp(display, keyChar, runEventQueue);
    }

    public static void pressKeyCharCombination(Display display, char[] keyChars) {
        SWTEventHelper.pressKeyCharCombination(display, keyChars, true);
    }

    public static void pressKeyCharCombination(Display display, char[] keyChars, boolean runEventQueue) {
        char[] cArray = keyChars;
        int n = keyChars.length;
        int n2 = 0;
        while (n2 < n) {
            char keyChar = cArray[n2];
            SWTEventHelper.keyCharDown(display, keyChar, runEventQueue);
            ++n2;
        }
        int i = keyChars.length - 1;
        while (i >= 0) {
            SWTEventHelper.keyCharUp(display, keyChars[i], runEventQueue);
            --i;
        }
    }

    public static void keyCharDown(Display display, char keyChar, boolean runEventQueue) {
        SWTEventHelper.keyCharEvent(display, 1, keyChar, runEventQueue);
    }

    public static void keyCharUp(Display display, char keyChar, boolean runEventQueue) {
        SWTEventHelper.keyCharEvent(display, 2, keyChar, runEventQueue);
    }

    public static void keyCharEvent(Display display, int type, char keyChar, boolean runEventQueue) {
        SWTEventHelper.fgKeyCharEvent.type = type;
        SWTEventHelper.fgKeyCharEvent.character = keyChar;
        SWTEventHelper.postEvent(display, fgKeyCharEvent, runEventQueue);
    }

    private static void postEvent(final Display display, final Event event, boolean runEventQueue) {
        DisplayHelper helper = new DisplayHelper(){

            @Override
            public boolean condition() {
                return display.post(event);
            }
        };
        Assert.assertTrue((boolean)helper.waitForCondition(display, 1000L));
        if (runEventQueue) {
            EditorTestHelper.runEventQueue();
        }
    }

    public static void mouseMoveEvent(Display display, int x, int y, boolean runEventQueue) {
        SWTEventHelper.fgMouseMoveEvent.type = 5;
        SWTEventHelper.fgMouseMoveEvent.x = x;
        SWTEventHelper.fgMouseMoveEvent.y = y;
        SWTEventHelper.postEvent(display, fgMouseMoveEvent, runEventQueue);
    }

    public static void mouseDownEvent(Display display, int button, boolean runEventQueue) {
        SWTEventHelper.mouseButtonEvent(display, 3, button, runEventQueue);
    }

    public static void mouseUpEvent(Display display, int button, boolean runEventQueue) {
        SWTEventHelper.mouseButtonEvent(display, 4, button, runEventQueue);
    }

    public static void mouseButtonEvent(Display display, int type, int button, boolean runEventQueue) {
        SWTEventHelper.fgMouseButtonEvent.type = type;
        SWTEventHelper.fgMouseButtonEvent.button = button;
        SWTEventHelper.postEvent(display, fgMouseButtonEvent, runEventQueue);
    }

    public static boolean performDnD(Widget startItem, Widget dropItem) {
        Tree startControl;
        Rectangle boundsStart = null;
        Rectangle boundsEnd = null;
        if (startItem instanceof TreeItem) {
            TreeItem t = (TreeItem)startItem;
            startControl = t.getParent();
            boundsStart = Display.getCurrent().map((Control)startControl, null, ((TreeItem)startItem).getBounds());
        } else if (startItem instanceof Control) {
            Control c = (Control)startItem;
            startControl = c;
            boundsStart = Display.getCurrent().map((Control)startControl, null, startControl.getBounds());
        } else {
            throw new RuntimeException(startItem.getClass().getName());
        }
        if (dropItem instanceof TreeItem) {
            boundsEnd = Display.getCurrent().map((Control)((TreeItem)dropItem).getParent(), null, ((TreeItem)dropItem).getBounds());
        } else if (dropItem instanceof Control) {
            boundsEnd = Display.getCurrent().map((Control)dropItem, null, ((Control)dropItem).getBounds());
        }
        startControl.addDragDetectListener(e -> {
            boolean bl = _dragDetected = true;
        });
        int count = 0;
        _dragDetected = false;
        while (!_dragDetected && ++count < 4) {
            SWTEventHelper.performDnDInternal(boundsStart, boundsEnd);
            if (_dragDetected) continue;
            if (count < 4) {
                System.out.println("WARNING: DnD failed - drag gesture not detected retrying");
            }
            DisplayHelper.sleep(Display.getCurrent(), 1000L);
        }
        if (!_dragDetected) {
            System.out.println("WARNING: DnD FAILED after " + count + " tries, giving up");
        }
        return _dragDetected;
    }

    public static void performDnDInternal(Rectangle boundsStart, Rectangle boundsEnd) {
        int fudge = 0;
        int gestureSize = 10;
        int xstart = boundsStart.x + fudge;
        int ystart = boundsStart.y + fudge;
        int xend = boundsEnd.x + fudge;
        int yend = boundsEnd.y + fudge;
        boolean possibleTrue = true;
        if (Platform.getOS().equals("win32")) {
            possibleTrue = false;
            gestureSize = 3;
        }
        SWTEventHelper.mouseMoveEvent(Display.getCurrent(), xstart, ystart, false);
        SWTEventHelper.mouseDownEvent(Display.getCurrent(), 1, false);
        SWTEventHelper.mouseMoveEvent(Display.getCurrent(), xstart + gestureSize, ystart, possibleTrue);
        SWTEventHelper.mouseMoveEvent(Display.getCurrent(), xstart, ystart, possibleTrue);
        while (xstart != xend) {
            SWTEventHelper.mouseMoveEvent(Display.getCurrent(), xstart, ystart, false);
            if (xstart < xend) {
                ++xstart;
                continue;
            }
            --xstart;
        }
        while (ystart != yend) {
            SWTEventHelper.mouseMoveEvent(Display.getCurrent(), xstart, ystart, false);
            if (ystart < yend) {
                ++ystart;
                continue;
            }
            --ystart;
        }
        SWTEventHelper.mouseMoveEvent(Display.getCurrent(), xend, yend, possibleTrue);
        SWTEventHelper.mouseUpEvent(Display.getCurrent(), 1, possibleTrue);
        DisplayHelper.sleep(Display.getCurrent(), 100L);
    }
}

