/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public final class TestRunLogUtil {
    private static final String LINE_BREAK = System.lineSeparator();
    public static TestWatcher LOG_TESTRUN = new TestWatcher(){

        protected void starting(Description description) {
            System.out.println(TestRunLogUtil.formatTestStartMessage(description.getMethodName()));
        }

        protected void failed(Throwable e, Description description) {
            System.out.println(description.getMethodName() + " failed:");
            e.printStackTrace(System.out);
        }

        protected void finished(Description description) {
            System.out.println(TestRunLogUtil.formatTestFinishedMessage(description.getMethodName()));
        }
    };

    public static String formatTestStartMessage(String testName) {
        return "----- " + testName + LINE_BREAK + testName + ": setUp...";
    }

    public static String formatTestFinishedMessage(String testName) {
        return testName + ": tearDown...\n";
    }

    private TestRunLogUtil() {
    }
}

