/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public final class UITestUtil {
    private UITestUtil() {
    }

    public static IAdaptable getPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IWorkbenchWindow openTestWindow() {
        return UITestUtil.openTestWindow("org.eclipse.ui.tests.harness.util.EmptyPerspective");
    }

    public static IWorkbenchWindow openTestWindow(String perspectiveId) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().openWorkbenchWindow(perspectiveId, UITestUtil.getPageInput());
            UITestUtil.waitOnShell(window.getShell());
            return window;
        }
        catch (WorkbenchException e) {
            UITestUtil.fail("Problem opening test window", e);
            return null;
        }
    }

    private static void fail(String message, Throwable e) {
        if (e instanceof CoreException) {
            IStatus status = ((CoreException)e).getStatus();
            UITestUtil.write(status, 0);
        } else {
            e.printStackTrace();
        }
        throw new AssertionError(message, e);
    }

    private static void indent(OutputStream output, int indent) {
        int i = 0;
        while (i < indent) {
            try {
                output.write("\t".getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
    }

    private static void write(IStatus status, int indent) {
        PrintStream output = System.out;
        UITestUtil.indent(output, indent);
        output.println("Severity: " + status.getSeverity());
        UITestUtil.indent(output, indent);
        output.println("Plugin ID: " + status.getPlugin());
        UITestUtil.indent(output, indent);
        output.println("Code: " + status.getCode());
        UITestUtil.indent(output, indent);
        output.println("Message: " + status.getMessage());
        if (status.getException() != null) {
            UITestUtil.indent(output, indent);
            output.print("Exception: ");
            status.getException().printStackTrace(output);
        }
        if (status.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = status.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                UITestUtil.write(child, indent + 1);
                ++n2;
            }
        }
    }

    public static IWorkbenchPage[] openTestPage(IWorkbenchWindow win, int pageTotal) {
        try {
            IWorkbenchPage[] pages = new IWorkbenchPage[pageTotal];
            IAdaptable input = UITestUtil.getPageInput();
            int i = 0;
            while (i < pageTotal) {
                pages[i] = win.openPage("org.eclipse.ui.tests.harness.util.EmptyPerspective", input);
                ++i;
            }
            return pages;
        }
        catch (WorkbenchException e) {
            UITestUtil.fail("Problem opening test page", e);
            return null;
        }
    }

    public static IWorkbenchPage openTestPage(IWorkbenchWindow win) {
        IWorkbenchPage[] pages = UITestUtil.openTestPage(win, 1);
        if (pages != null) {
            return pages[0];
        }
        return null;
    }

    public static void closeAllPages(IWorkbenchWindow window) {
        IWorkbenchPage[] pages;
        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            page.close();
            ++n2;
        }
    }

    public static void processEvents() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    public static boolean processEventsUntil(Condition condition, long timeout) {
        long startTime = System.currentTimeMillis();
        Display display = PlatformUI.getWorkbench().getDisplay();
        while (condition == null || !condition.compute()) {
            if (timeout != -1L && System.currentTimeMillis() - startTime > timeout) {
                return false;
            }
            while (display.readAndDispatch()) {
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public static void waitForJobs(long minTimeMs, long maxTimeMs) {
        if (maxTimeMs < minTimeMs) {
            throw new IllegalArgumentException("Max time is smaller as min time!");
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < minTimeMs) {
            UITestUtil.processEvents();
            UITestUtil.sleep(10L);
        }
        while (!Job.getJobManager().isIdle() && System.currentTimeMillis() - start < maxTimeMs) {
            UITestUtil.processEvents();
            UITestUtil.sleep(10L);
        }
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public static boolean forceActive(Shell shell) {
        Shell s;
        Shell[] shells;
        Display display = PlatformUI.getWorkbench().getDisplay();
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            s = shellArray[n2];
            if (s.isVisible()) {
                s.setMinimized(true);
            }
            UITestUtil.processEvents();
            ++n2;
        }
        UITestUtil.waitForJobs(200L, 3000L);
        shellArray = shells;
        n = shells.length;
        n2 = 0;
        while (n2 < n) {
            s = shellArray[n2];
            if (s.isVisible()) {
                s.setMinimized(false);
            }
            UITestUtil.processEvents();
            ++n2;
        }
        UITestUtil.waitForJobs(200L, 3000L);
        shell.setVisible(false);
        UITestUtil.processEvents();
        shell.setMinimized(true);
        UITestUtil.processEvents();
        UITestUtil.waitForJobs(200L, 3000L);
        shell.setVisible(true);
        UITestUtil.processEvents();
        shell.setMinimized(false);
        UITestUtil.processEvents();
        shell.forceActive();
        UITestUtil.processEvents();
        shell.forceFocus();
        UITestUtil.processEvents();
        UITestUtil.waitForJobs(400L, 3000L);
        return display.getActiveShell() == shell;
    }

    static void waitOnShell(Shell shell) {
        UITestUtil.processEvents();
        UITestUtil.waitForJobs(100L, 5000L);
    }

    public static interface Condition {
        public boolean compute();
    }
}

