/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.junit.Assert;
import org.junit.Test;

public class RefactoringContextTest {
    @Test
    public void testDisposeNormal() throws Exception {
        TestRefactoring ref = new TestRefactoring();
        TestRefactoringContext context = new TestRefactoringContext(ref);
        new PerformRefactoringOperation((RefactoringContext)context, 6).run(null);
        Assert.assertEquals((long)1L, (long)context.fDisposeCalls);
        try {
            context.dispose();
        }
        catch (IllegalStateException e) {
            return;
        }
        Assert.fail((String)"dispose must not be called twice");
    }

    @Test
    public void testDisposeInitialFailed() throws Exception {
        TestRefactoring ref = new TestRefactoring();
        ref.fInitialConditionStatus.addFatalError("fail");
        TestRefactoringContext context = new TestRefactoringContext(ref);
        new PerformRefactoringOperation((RefactoringContext)context, 6).run(null);
        Assert.assertEquals((long)1L, (long)context.fDisposeCalls);
    }

    @Test
    public void testDisposeFinalFailed() throws Exception {
        TestRefactoring ref = new TestRefactoring();
        ref.fFinalConditionStatus.addFatalError("fail");
        TestRefactoringContext context = new TestRefactoringContext(ref);
        new PerformRefactoringOperation((RefactoringContext)context, 6).run(null);
        Assert.assertEquals((long)1L, (long)context.fDisposeCalls);
    }

    @Test
    public void testDisposeChangeFailed() throws Exception {
        TestRefactoring ref = new TestRefactoring(){

            @Override
            public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                throw new OperationCanceledException();
            }
        };
        TestRefactoringContext context = new TestRefactoringContext(ref);
        boolean cancelled = false;
        try {
            new PerformRefactoringOperation((RefactoringContext)context, 6).run(null);
        }
        catch (OperationCanceledException e) {
            cancelled = true;
        }
        Assert.assertTrue((boolean)cancelled);
        Assert.assertEquals((long)1L, (long)context.fDisposeCalls);
    }

    private static class TestRefactoring
    extends Refactoring {
        RefactoringStatus fInitialConditionStatus = new RefactoringStatus();
        RefactoringStatus fFinalConditionStatus = new RefactoringStatus();

        private TestRefactoring() {
        }

        public String getName() {
            return "test Refactoring";
        }

        public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return this.fInitialConditionStatus;
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return this.fFinalConditionStatus;
        }

        public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new NullChange();
        }
    }

    private static class TestRefactoringContext
    extends RefactoringContext {
        int fDisposeCalls;

        public TestRefactoringContext(Refactoring refactoring) {
            super(refactoring);
        }

        public void dispose() {
            super.dispose();
            ++this.fDisposeCalls;
        }
    }
}

