/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.history;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.tests.history.MockRefactoringDescriptor;

public class MockRefactoring
extends Refactoring {
    private Map<String, String> fArguments = Collections.emptyMap();
    private String fComment = "A mock comment";
    private String fDescription = "A mock description";
    private int fFlags = 1;
    private String fProject = "MockProject";

    public MockRefactoring() {
    }

    public MockRefactoring(String project, String description, String comment, Map<String, String> arguments, int flags) {
        this.fProject = project;
        this.fDescription = description;
        this.fComment = comment;
        this.fArguments = arguments;
        this.fFlags = flags;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return new NullChange(){

            public ChangeDescriptor getDescriptor() {
                MockRefactoringDescriptor descriptor = MockRefactoring.this.createRefactoringDescriptor();
                return new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor);
            }
        };
    }

    public MockRefactoringDescriptor createRefactoringDescriptor() {
        return new MockRefactoringDescriptor(this.fProject, this.fDescription, this.fComment, this.fArguments, this.fFlags);
    }

    public String getName() {
        return "mock";
    }
}

