/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.history;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.tests.history.MockRefactoringDescriptor;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringDescriptorProxyAdapter;
import org.junit.Assert;
import org.junit.Test;

public class RefactoringHistorySerializationTests {
    private static void compareReadHistory(RefactoringDescriptor[] descriptors, int flags, String xml, boolean ioException) throws CoreException {
        ArrayList<RefactoringDescriptorProxyAdapter> list = new ArrayList<RefactoringDescriptorProxyAdapter>();
        RefactoringDescriptor[] refactoringDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringDescriptor descriptor = refactoringDescriptorArray[n2];
            list.add(new RefactoringDescriptorProxyAdapter(descriptor));
            ++n2;
        }
        ByteArrayInputStream stream = null;
        stream = ioException ? new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)){

            @Override
            public int read(byte[] b) throws IOException {
                throw new IOException();
            }
        } : new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        RefactoringHistory result = RefactoringCore.getHistoryService().readRefactoringHistory((InputStream)stream, flags);
        RefactoringDescriptorProxy[] actualProxies = result.getDescriptors();
        RefactoringDescriptorProxy[] expectedProxies = list.toArray(new RefactoringDescriptorProxy[list.size()]);
        Assert.assertEquals((String)"The number of refactoring descriptors is incorrect.", (long)expectedProxies.length, (long)actualProxies.length);
        int index = 0;
        while (index < expectedProxies.length) {
            RefactoringDescriptor expectedDescriptor = expectedProxies[index].requestDescriptor(null);
            Assert.assertNotNull((String)"Expected refactoring descriptor cannot be resolved.", (Object)expectedDescriptor);
            RefactoringDescriptor actualDescriptor = actualProxies[index].requestDescriptor(null);
            Assert.assertNotNull((String)"Actual refactoring descriptor cannot be resolved.", (Object)actualDescriptor);
            Assert.assertEquals((String)"Expected refactoring descriptor is not equal to actual one:", (Object)expectedDescriptor.toString(), (Object)actualDescriptor.toString());
            ++index;
        }
    }

    private static void compareWrittenDescriptor(RefactoringSessionDescriptor descriptor, boolean time, String xml) throws CoreException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        RefactoringCore.getHistoryService().writeRefactoringSession(descriptor, (OutputStream)stream, time);
        Assert.assertEquals((String)"The refactoring descriptor has not been correctly serialized:", (Object)RefactoringHistorySerializationTests.convertLineDelimiters(xml), (Object)stream.toString(StandardCharsets.UTF_8));
    }

    private static String concatenate(String[] lines, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(lines[i]);
            ++i;
        }
        return buffer.toString();
    }

    private static String[] convertIntoLines(String input) {
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(input);
            int size = tracker.getNumberOfLines();
            String[] result = new String[size];
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                result[i] = input.substring(offset, offset + region.getLength());
                ++i;
            }
            return result;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private static String convertLineDelimiters(String xml) {
        String delimiter = System.lineSeparator();
        Assert.assertNotNull((String)"Could not determine line separator.", (Object)delimiter);
        if (!"\n".equals(delimiter)) {
            xml = RefactoringHistorySerializationTests.concatenate(RefactoringHistorySerializationTests.convertIntoLines(xml), delimiter);
        }
        return xml;
    }

    @Test
    public void testReadDescriptor0() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session comment=\"A mock comment\" version=\"1.0\">\n<refactoring arg0=\"value0\" arg1=\"value1\" arg2=\"value2\" comment=\"A mock comment\" description=\"A mock refactoring\" flags=\"3\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\"/>\n</session>\n";
        int flags = 0;
        MockRefactoringDescriptor descriptor = new MockRefactoringDescriptor("test0", "A mock refactoring", "A mock comment", 3);
        Map<String, String> arguments = descriptor.getArguments();
        arguments.put("arg0", "value0");
        arguments.put("arg1", "value1");
        arguments.put("arg2", "value2");
        RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{descriptor}, flags, xml, false);
    }

    @Test
    public void testReadDescriptor1() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session comment=\"A mock comment\" version=\"1.0\">\n<refactoring arg0=\"value 0\" arg1=\"value 1\" arg2=\"value 2\" comment=\"A mock comment\" description=\"A mock refactoring\" flags=\"6\" id=\"org.eclipse.ltk.core.mock\" project=\"test1\"/>\n</session>\n";
        int flags = 0;
        MockRefactoringDescriptor descriptor = new MockRefactoringDescriptor("test1", "A mock refactoring", "A mock comment", 6);
        Map<String, String> arguments = descriptor.getArguments();
        arguments.put("arg0", "value 0");
        arguments.put("arg1", "value 1");
        arguments.put("arg2", "value 2");
        RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{descriptor}, flags, xml, false);
    }

    @Test
    public void testReadDescriptor10() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"1.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>\n";
        int flags = 4;
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        try {
            RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{third}, flags, xml, true);
        }
        catch (CoreException exception) {
            Assert.assertEquals((String)"Wrong status code for refactoring history io error:", (long)10006L, (long)exception.getStatus().getCode());
        }
    }

    @Test
    public void testReadDescriptor11() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"1.0\">\n<refact oring arg0=\"value 0\" com ment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>\n";
        int flags = 4;
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        try {
            RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{third}, flags, xml, false);
        }
        catch (CoreException exception) {
            Assert.assertEquals((String)"Wrong status code for refactoring history io error:", (long)10006L, (long)exception.getStatus().getCode());
        }
    }

    @Test
    public void testReadDescriptor12() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"1.0\">\n<refactoring arg0=\"value 0\" com ment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>\n";
        int flags = 4;
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        try {
            RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{third}, flags, xml, true);
        }
        catch (CoreException exception) {
            Assert.assertEquals((String)"Wrong status code for refactoring history io error:", (long)10006L, (long)exception.getStatus().getCode());
        }
    }

    @Test
    public void testReadDescriptor2() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"1.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n</session>\n";
        int flags = 0;
        MockRefactoringDescriptor descriptor = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        Map<String, String> arguments = descriptor.getArguments();
        arguments.put("arg0", "value 0");
        RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{descriptor}, flags, xml, false);
    }

    @Test
    public void testReadDescriptor3() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"1.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\"/>\n</session>\n";
        int flags = 0;
        MockRefactoringDescriptor first = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        MockRefactoringDescriptor second = new MockRefactoringDescriptor(null, "Another mock refactoring", "No comment", 1);
        Map<String, String> arguments = first.getArguments();
        arguments.put("arg0", "value 0");
        arguments = second.getArguments();
        arguments.put("arg1", "value 1");
        RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{first, second}, flags, xml, false);
    }

    @Test
    public void testReadDescriptor4() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"1.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>\n";
        int flags = 0;
        MockRefactoringDescriptor first = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        MockRefactoringDescriptor second = new MockRefactoringDescriptor(null, "Another mock refactoring", "No comment", 1);
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = first.getArguments();
        arguments.put("arg0", "value 0");
        arguments = second.getArguments();
        arguments.put("arg1", "value 1");
        arguments.put("version", "1.0");
        arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{first, second, third}, flags, xml, false);
    }

    @Test
    public void testReadDescriptor5() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"1.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>\n";
        int flags = 1;
        MockRefactoringDescriptor second = new MockRefactoringDescriptor(null, "Another mock refactoring", "No comment", 1);
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = second.getArguments();
        arguments.put("arg1", "value 1");
        arguments.put("version", "1.0");
        arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{second, third}, flags, xml, false);
    }

    @Test
    public void testReadDescriptor6() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"1.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>\n";
        int flags = 4;
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{third}, flags, xml, false);
    }

    @Test
    public void testReadDescriptor7() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"3.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>\n";
        int flags = 4;
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        try {
            RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{third}, flags, xml, false);
        }
        catch (CoreException exception) {
            Assert.assertEquals((String)"Wrong status code for unsupported refactoring history version exception:", (long)10005L, (long)exception.getStatus().getCode());
        }
    }

    @Test
    public void testReadDescriptor8() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session>\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>\n";
        int flags = 4;
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        try {
            RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{third}, flags, xml, false);
        }
        catch (CoreException exception) {
            Assert.assertEquals((String)"Wrong status code for missing refactoring history version exception:", (long)10004L, (long)exception.getStatus().getCode());
        }
    }

    @Test
    public void testReadDescriptor9() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<error version=\"1.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</error>\n";
        int flags = 4;
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        try {
            RefactoringHistorySerializationTests.compareReadHistory(new RefactoringDescriptor[]{third}, flags, xml, false);
        }
        catch (CoreException exception) {
            Assert.assertEquals((String)"Wrong status code for refactoring history format exception:", (long)10007L, (long)exception.getStatus().getCode());
        }
    }

    @Test
    public void testWriteDescriptor0() throws Exception {
        MockRefactoringDescriptor descriptor = new MockRefactoringDescriptor("test0", "A mock refactoring", "A mock comment", 3);
        Map<String, String> arguments = descriptor.getArguments();
        arguments.put("arg0", "value0");
        arguments.put("arg1", "value1");
        arguments.put("arg2", "value2");
        String version = "1.0";
        String comment = "A mock comment";
        RefactoringSessionDescriptor session = new RefactoringSessionDescriptor(new RefactoringDescriptor[]{descriptor}, version, comment);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session comment=\"A mock comment\" version=\"1.0\">\n<refactoring arg0=\"value0\" arg1=\"value1\" arg2=\"value2\" comment=\"A mock comment\" description=\"A mock refactoring\" flags=\"3\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\"/>\n</session>";
        RefactoringHistorySerializationTests.compareWrittenDescriptor(session, true, xml);
    }

    @Test
    public void testWriteDescriptor1() throws Exception {
        MockRefactoringDescriptor descriptor = new MockRefactoringDescriptor("test1", "A mock refactoring", "A mock comment", 6);
        Map<String, String> arguments = descriptor.getArguments();
        arguments.put("arg0", "value 0");
        arguments.put("arg1", "value 1");
        arguments.put("arg2", "value 2");
        String version = "2.0";
        String comment = "A mock comment";
        RefactoringSessionDescriptor session = new RefactoringSessionDescriptor(new RefactoringDescriptor[]{descriptor}, version, comment);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session comment=\"A mock comment\" version=\"2.0\">\n<refactoring arg0=\"value 0\" arg1=\"value 1\" arg2=\"value 2\" comment=\"A mock comment\" description=\"A mock refactoring\" flags=\"6\" id=\"org.eclipse.ltk.core.mock\" project=\"test1\"/>\n</session>";
        RefactoringHistorySerializationTests.compareWrittenDescriptor(session, true, xml);
    }

    @Test
    public void testWriteDescriptor2() throws Exception {
        MockRefactoringDescriptor descriptor = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        Map<String, String> arguments = descriptor.getArguments();
        arguments.put("arg0", "value 0");
        String version = "2.0";
        String comment = null;
        RefactoringSessionDescriptor session = new RefactoringSessionDescriptor(new RefactoringDescriptor[]{descriptor}, version, comment);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"2.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n</session>";
        RefactoringHistorySerializationTests.compareWrittenDescriptor(session, true, xml);
    }

    @Test
    public void testWriteDescriptor3() throws Exception {
        MockRefactoringDescriptor first = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        MockRefactoringDescriptor second = new MockRefactoringDescriptor(null, "Another mock refactoring", "No comment", 1);
        Map<String, String> arguments = first.getArguments();
        arguments.put("arg0", "value 0");
        arguments = second.getArguments();
        arguments.put("arg1", "value 1");
        String version = "1.0";
        String comment = null;
        RefactoringSessionDescriptor session = new RefactoringSessionDescriptor(new RefactoringDescriptor[]{first, second}, version, comment);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"1.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\"/>\n</session>";
        RefactoringHistorySerializationTests.compareWrittenDescriptor(session, false, xml);
    }

    @Test
    public void testWriteDescriptor4() throws Exception {
        MockRefactoringDescriptor first = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        MockRefactoringDescriptor second = new MockRefactoringDescriptor(null, "Another mock refactoring", "No comment", 1);
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = first.getArguments();
        arguments.put("arg0", "value 0");
        arguments = second.getArguments();
        arguments.put("arg1", "value 1");
        arguments.put("version", "1.0");
        arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        String version = "3.0";
        String comment = null;
        RefactoringSessionDescriptor session = new RefactoringSessionDescriptor(new RefactoringDescriptor[]{first, second, third}, version, comment);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"3.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>";
        RefactoringHistorySerializationTests.compareWrittenDescriptor(session, true, xml);
    }

    @Test
    public void testWriteDescriptor5() throws Exception {
        MockRefactoringDescriptor first = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        MockRefactoringDescriptor second = new MockRefactoringDescriptor(null, "Another mock refactoring", "No comment", 1);
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = first.getArguments();
        arguments.put("arg 0", "value 0");
        arguments = second.getArguments();
        arguments.put("arg1", "value 1");
        arguments.put("version", "1.0");
        arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        String version = "3.0";
        String comment = null;
        RefactoringSessionDescriptor session = new RefactoringSessionDescriptor(new RefactoringDescriptor[]{first, second, third}, version, comment);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"3.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>";
        try {
            RefactoringHistorySerializationTests.compareWrittenDescriptor(session, true, xml);
        }
        catch (CoreException exception) {
            Assert.assertEquals((String)"Wrong status code for refactoring history format exception:", (long)10007L, (long)exception.getStatus().getCode());
        }
    }

    @Test
    public void testWriteDescriptor6() throws Exception {
        MockRefactoringDescriptor first = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        MockRefactoringDescriptor second = new MockRefactoringDescriptor(null, "Another mock refactoring", "No comment", 1);
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = first.getArguments();
        arguments.put("", "value 0");
        arguments = second.getArguments();
        arguments.put("arg1", "value 1");
        arguments.put("version", "1.0");
        arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        String version = "3.0";
        String comment = null;
        RefactoringSessionDescriptor session = new RefactoringSessionDescriptor(new RefactoringDescriptor[]{first, second, third}, version, comment);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"3.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>";
        try {
            RefactoringHistorySerializationTests.compareWrittenDescriptor(session, true, xml);
        }
        catch (CoreException exception) {
            Assert.assertEquals((String)"Wrong status code for refactoring history format exception:", (long)10007L, (long)exception.getStatus().getCode());
        }
    }

    @Test
    public void testWriteDescriptor7() throws Exception {
        MockRefactoringDescriptor first = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        MockRefactoringDescriptor second = new MockRefactoringDescriptor(null, "Another mock refactoring", "No comment", 1);
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = first.getArguments();
        arguments.put("", null);
        arguments = second.getArguments();
        arguments.put("arg1", "value 1");
        arguments.put("version", "1.0");
        arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        String version = "3.0";
        String comment = null;
        RefactoringSessionDescriptor session = new RefactoringSessionDescriptor(new RefactoringDescriptor[]{first, second, third}, version, comment);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"3.0\">\n<refactoring arg0=\"value 0\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>";
        try {
            RefactoringHistorySerializationTests.compareWrittenDescriptor(session, true, xml);
        }
        catch (CoreException exception) {
            Assert.assertEquals((String)"Wrong status code for refactoring history format exception:", (long)10007L, (long)exception.getStatus().getCode());
        }
    }

    @Test
    public void testWriteDescriptor8() throws Exception {
        MockRefactoringDescriptor first = new MockRefactoringDescriptor(null, "A mock refactoring", "A mock comment", 0);
        MockRefactoringDescriptor second = new MockRefactoringDescriptor(null, "Another mock refactoring", "No comment", 1);
        MockRefactoringDescriptor third = new MockRefactoringDescriptor("test0", "Yet another mock refactoring", null, 5);
        Map<String, String> arguments = first.getArguments();
        arguments.put("arg0", "");
        arguments = second.getArguments();
        arguments.put("arg1", "value 1");
        arguments.put("version", "1.0");
        arguments = third.getArguments();
        arguments.put("arg2", "value 2");
        arguments.put("version", "1.1");
        String version = "3.0";
        String comment = null;
        RefactoringSessionDescriptor session = new RefactoringSessionDescriptor(new RefactoringDescriptor[]{first, second, third}, version, comment);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<session version=\"3.0\">\n<refactoring arg0=\"\" comment=\"A mock comment\" description=\"A mock refactoring\" id=\"org.eclipse.ltk.core.mock\"/>\n<refactoring arg1=\"value 1\" comment=\"No comment\" description=\"Another mock refactoring\" flags=\"1\" id=\"org.eclipse.ltk.core.mock\" version=\"1.0\"/>\n<refactoring arg2=\"value 2\" description=\"Yet another mock refactoring\" flags=\"5\" id=\"org.eclipse.ltk.core.mock\" project=\"test0\" version=\"1.1\"/>\n</session>";
        RefactoringHistorySerializationTests.compareWrittenDescriptor(session, true, xml);
    }
}

