/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.history;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringExecutionListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringExecutionEvent;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistoryEvent;
import org.eclipse.ltk.core.refactoring.tests.history.MockRefactoring;
import org.eclipse.ltk.core.refactoring.tests.history.MockRefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.tests.util.SimpleTestProject;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringDescriptorProxyAdapter;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;

public class RefactoringHistoryServiceTests {
    private static final int BREAKING_NUMBER = 20;
    private static final int COMMON_NUMBER = 20;
    private static final int CUSTOM_FLAG = 1024;
    private static final int CUSTOM_NUMBER = 5;
    private static final int NONE_NUMBER = 10;
    private static final int STAMP_FACTOR = 10000000;
    private static final int STRUCTURAL_NUMBER = 10;
    private static final int TOTAL_PROJECT_NUMBER = 45;
    private static final int TOTALZ_HISTORY_NUMBER = 65;
    private SimpleTestProject fProject;

    private void assertDescendingSortOrder(RefactoringDescriptorProxy[] proxies) {
        int index = 0;
        while (index < proxies.length - 1) {
            Assert.assertTrue((String)"", (proxies[index].getTimeStamp() > proxies[index + 1].getTimeStamp() ? 1 : 0) != 0);
            ++index;
        }
    }

    private RefactoringDescriptor executeRefactoring(String project, int index, int flags) throws CoreException {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        try {
            service.setOverrideTimeStamp((long)((index + 1) * 10000000));
            MockRefactoring refactoring = new MockRefactoring(project, "A mock description number " + index, "A mock comment number " + index, Collections.emptyMap(), flags);
            MockRefactoringDescriptor descriptor = refactoring.createRefactoringDescriptor();
            PerformRefactoringOperation operation = new PerformRefactoringOperation((Refactoring)refactoring, 6);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, null);
            MockRefactoringDescriptor mockRefactoringDescriptor = descriptor;
            return mockRefactoringDescriptor;
        }
        finally {
            service.setOverrideTimeStamp(-1L);
        }
    }

    private void setSharedRefactoringHistory(boolean shared) throws BackingStoreException, CoreException {
        IEclipsePreferences preferences = new ProjectScope(this.fProject.getProject()).getNode("org.eclipse.ltk.core.refactoring");
        preferences.put("org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", Boolean.toString(shared));
        preferences.flush();
        RefactoringHistoryService.setSharedRefactoringHistory((IProject)this.fProject.getProject(), (boolean)shared, null);
    }

    @Before
    public void setUp() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        service.connect();
        this.fProject = new SimpleTestProject();
        this.setSharedRefactoringHistory(true);
        Assert.assertTrue((String)"Refactoring history should be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)this.fProject.getProject()));
        IFolder folder = this.fProject.getProject().getFolder(".refactorings");
        Assert.assertFalse((String)"Refactoring history folder should not exist.", (boolean)folder.exists());
        this.setUpTestProjectRefactorings();
        Assert.assertTrue((String)"Refactoring history folder should exist", (boolean)folder.exists());
    }

    private void setUpTestProjectRefactorings() throws CoreException {
        String name = this.fProject.getProject().getName();
        int index = 0;
        while (index < 10) {
            this.executeRefactoring(name, index, 0);
            ++index;
        }
        index = 0;
        while (index < 20) {
            this.executeRefactoring(name, index + 10, 1);
            ++index;
        }
        index = 0;
        while (index < 10) {
            this.executeRefactoring(name, index + 10 + 20, 2);
            ++index;
        }
        index = 0;
        while (index < 5) {
            this.executeRefactoring(name, index + 10 + 20 + 10, 1024);
            ++index;
        }
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), null);
        Assert.assertEquals((long)45L, (long)history.getDescriptors().length);
    }

    private void setUpWorkspaceRefactorings() throws CoreException {
        int index = 0;
        while (index < 20) {
            this.executeRefactoring(null, index + 45, 1);
            ++index;
        }
    }

    @After
    public void tearDown() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        service.deleteRefactoringHistory(this.fProject.getProject(), null);
        RefactoringHistory history = service.getWorkspaceHistory(null);
        service.deleteRefactoringDescriptors(history.getDescriptors(), null);
        history = service.getWorkspaceHistory(null);
        Assert.assertTrue((String)"Refactoring history must be empty", (boolean)history.isEmpty());
        service.disconnect();
        this.fProject.delete();
    }

    @Test
    public void testDeleteProjectHistory0() throws Exception {
        this.setUpWorkspaceRefactorings();
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        service.deleteRefactoringHistory(project, null);
        RefactoringHistory projectHistory = service.getProjectHistory(project, null);
        Assert.assertEquals((String)"Refactoring history has wrong size:", (long)20L, (long)projectHistory.getDescriptors().length);
        RefactoringHistory workspaceHistory = service.getWorkspaceHistory(null);
        RefactoringDescriptorProxy[] descriptors = workspaceHistory.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size:", (long)20L, (long)descriptors.length);
        RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringDescriptorProxy descriptor = refactoringDescriptorProxyArray[n2];
            Assert.assertNull((String)("Workspace refactoring should have no project attribute set:\n\n" + descriptor.toString()), (Object)descriptor.getProject());
            ++n2;
        }
    }

    @Test
    public void testDeleteProjectHistory1() throws Exception {
        this.setUpWorkspaceRefactorings();
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory workspaceHistory = service.getWorkspaceHistory(null);
        HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>();
        RefactoringDescriptorProxy[] refactoringDescriptorProxyArray = workspaceHistory.getDescriptors();
        int n = refactoringDescriptorProxyArray.length;
        int n2 = 0;
        while (n2 < n) {
            RefactoringDescriptorProxy descriptor = refactoringDescriptorProxyArray[n2];
            if (descriptor.getProject() == null) {
                set.add(descriptor);
            }
            ++n2;
        }
        service.deleteRefactoringDescriptors(set.toArray(new RefactoringDescriptorProxy[set.size()]), null);
        workspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory projectHistory = service.getProjectHistory(project, null);
        Assert.assertEquals((String)"Refactoring history should be the same:", (Object)projectHistory, (Object)workspaceHistory);
        service.deleteRefactoringHistory(project, null);
        projectHistory = service.getProjectHistory(project, null);
        Assert.assertTrue((String)"Refactoring history should be empty", (boolean)projectHistory.isEmpty());
        workspaceHistory = service.getWorkspaceHistory(null);
        Assert.assertTrue((String)"Refactoring history should be empty", (boolean)workspaceHistory.isEmpty());
    }

    @Test
    public void testDeleteRefactoringDescriptors0() throws Exception {
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory projectHistory = service.getProjectHistory(project, null);
        Assert.assertFalse((String)"Refactoring history should not be empty", (boolean)projectHistory.isEmpty());
        service.deleteRefactoringDescriptors(projectHistory.getDescriptors(), null);
        projectHistory = service.getProjectHistory(project, null);
        projectHistory = service.getProjectHistory(project, null);
        Assert.assertTrue((String)"Refactoring history should be empty", (boolean)projectHistory.isEmpty());
        RefactoringHistory workspaceHistory = service.getWorkspaceHistory(null);
        Assert.assertTrue((String)"Refactoring history should be empty", (boolean)workspaceHistory.isEmpty());
    }

    @Test
    public void testDeleteRefactoringDescriptors1() throws Exception {
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory workspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory projectHistory = service.getProjectHistory(project, 0L, Long.MAX_VALUE, 1, null);
        Assert.assertFalse((String)"Refactoring history should not be empty", (boolean)projectHistory.isEmpty());
        service.deleteRefactoringDescriptors(projectHistory.getDescriptors(), null);
        RefactoringHistory afterHistory = service.getWorkspaceHistory(null);
        Assert.assertEquals((String)"", (long)(afterHistory.getDescriptors().length + 20), (long)workspaceHistory.getDescriptors().length);
    }

    @Test
    public void testPopDescriptor0() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor descriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 1024);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousProjectHistory.getDescriptors().length + 1), (long)nextProjectHistory.getDescriptors().length);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousWorkspaceHistory.getDescriptors().length + 1), (long)nextWorkspaceHistory.getDescriptors().length);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
            RefactoringCore.getUndoManager().performUndo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(2);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(2);
            RefactoringCore.getUndoManager().performRedo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(3);
            nextWorkspaceHistory = service.getWorkspaceHistory(null);
            nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousProjectHistory.getDescriptors().length + 1), (long)nextProjectHistory.getDescriptors().length);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousWorkspaceHistory.getDescriptors().length + 1), (long)nextWorkspaceHistory.getDescriptors().length);
            Assert.assertEquals((String)"Refactoring history should be the same", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            Assert.assertEquals((String)"Refactoring history should be the same", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    @Test
    public void testPopDescriptor1() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor firstDescriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 1024);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringDescriptor secondDescriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000001, 1);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousProjectHistory.getDescriptors().length + 2), (long)nextProjectHistory.getDescriptors().length);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousWorkspaceHistory.getDescriptors().length + 2), (long)nextWorkspaceHistory.getDescriptors().length);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(firstDescriptor), new RefactoringDescriptorProxyAdapter(secondDescriptor)})), (Object)previousProjectHistory);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(firstDescriptor), new RefactoringDescriptorProxyAdapter(secondDescriptor)})), (Object)previousWorkspaceHistory);
            RefactoringCore.getUndoManager().performUndo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(2);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(2);
            RefactoringCore.getUndoManager().performUndo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(2);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(2);
            RefactoringCore.getUndoManager().performRedo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(firstDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(3);
            RefactoringCore.getUndoManager().performRedo(null, null);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(secondDescriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(3);
            nextWorkspaceHistory = service.getWorkspaceHistory(null);
            nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousProjectHistory.getDescriptors().length + 2), (long)nextProjectHistory.getDescriptors().length);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousWorkspaceHistory.getDescriptors().length + 2), (long)nextWorkspaceHistory.getDescriptors().length);
            Assert.assertEquals((String)"Refactoring history should be the same", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(firstDescriptor), new RefactoringDescriptorProxyAdapter(secondDescriptor)})), (Object)previousProjectHistory);
            Assert.assertEquals((String)"Refactoring history should be the same", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(firstDescriptor), new RefactoringDescriptorProxyAdapter(secondDescriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    @Test
    public void testPushDescriptor0() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor descriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 1024);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousProjectHistory.getDescriptors().length + 1), (long)nextProjectHistory.getDescriptors().length);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousWorkspaceHistory.getDescriptors().length + 1), (long)nextWorkspaceHistory.getDescriptors().length);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    @Test
    public void testPushDescriptor1() throws Exception {
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor descriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 5);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousProjectHistory.getDescriptors().length + 1), (long)nextProjectHistory.getDescriptors().length);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousWorkspaceHistory.getDescriptors().length + 1), (long)nextWorkspaceHistory.getDescriptors().length);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    @Test
    public void testPushDescriptor2() throws Exception {
        this.setUpWorkspaceRefactorings();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousWorkspaceHistory = service.getWorkspaceHistory(null);
        RefactoringHistory previousProjectHistory = service.getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 0, null);
        RefactoringHistoryListener historyListener = new RefactoringHistoryListener();
        RefactoringExecutionListener executionListener = new RefactoringExecutionListener();
        try {
            historyListener.connect();
            executionListener.connect();
            RefactoringDescriptor descriptor = this.executeRefactoring(this.fProject.getProject().getName(), 1000000, 5);
            historyListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            historyListener.assertEventSource((IRefactoringHistoryService)service);
            historyListener.assertEventType(1);
            executionListener.assertEventDescriptor(new RefactoringDescriptorProxyAdapter(descriptor));
            executionListener.assertEventSource((IRefactoringHistoryService)service);
            executionListener.assertEventType(1);
            RefactoringHistory nextWorkspaceHistory = service.getWorkspaceHistory(null);
            RefactoringHistory nextProjectHistory = service.getProjectHistory(this.fProject.getProject(), null);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousProjectHistory, (Object)nextProjectHistory);
            Assert.assertNotSame((String)"Refactoring history should not be the same:", (Object)previousWorkspaceHistory, (Object)nextWorkspaceHistory);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousProjectHistory.getDescriptors().length + 1), (long)nextProjectHistory.getDescriptors().length);
            Assert.assertEquals((String)"Length of refactoring history should be one more:", (long)(previousWorkspaceHistory.getDescriptors().length + 1), (long)nextWorkspaceHistory.getDescriptors().length);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextProjectHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousProjectHistory);
            Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextWorkspaceHistory.removeAll((RefactoringHistory)new RefactoringHistoryImplementation((RefactoringDescriptorProxy[])new RefactoringDescriptorProxyAdapter[]{new RefactoringDescriptorProxyAdapter(descriptor)})), (Object)previousWorkspaceHistory);
        }
        finally {
            historyListener.disconnect();
            executionListener.disconnect();
        }
    }

    @Test
    public void testReadProjectHistory0() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)45L, (long)proxies.length);
    }

    @Test
    public void testReadProjectHistory1() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 0, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)45L, (long)proxies.length);
    }

    @Test
    public void testReadProjectHistory2() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 1, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)20L, (long)proxies.length);
    }

    @Test
    public void testReadProjectHistory3() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 2, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)10L, (long)proxies.length);
    }

    @Test
    public void testReadProjectHistory4() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 4, null);
        Assert.assertTrue((String)"Refactoring history should  be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)0L, (long)proxies.length);
    }

    @Test
    public void testReadProjectHistory5() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 1024, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)5L, (long)proxies.length);
    }

    @Test
    public void testReadProjectHistory6() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, 10000000L, 1024, null);
        Assert.assertTrue((String)"Refactoring history should  be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)0L, (long)proxies.length);
    }

    @Test
    public void testReadRefactoringHistory0() throws Exception {
        this.setUpWorkspaceRefactorings();
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)65L, (long)proxies.length);
    }

    @Test
    public void testReadRefactoringHistory1() throws Exception {
        this.setUpWorkspaceRefactorings();
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(0L, Long.MAX_VALUE, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)65L, (long)proxies.length);
    }

    @Test
    public void testReadWorkspaceHistory0() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(0L, 10000000L, null);
        Assert.assertFalse((String)"Refactoring history should  be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)1L, (long)proxies.length);
    }

    @Test
    public void testReadWorkspaceHistory1() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(0L, Long.MAX_VALUE, null);
        Assert.assertFalse((String)"Refactoring history should  be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)45L, (long)proxies.length);
    }

    @Test
    public void testReadWorkspaceHistory2() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(10000000L, 50000000L, null);
        Assert.assertFalse((String)"Refactoring history should  be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)5L, (long)proxies.length);
    }

    @Test
    public void testReadWorkspaceHistory3() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(30000000L, 50000000L, null);
        Assert.assertFalse((String)"Refactoring history should  be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)3L, (long)proxies.length);
    }

    @Test
    public void testSharing0() throws Exception {
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousHistory = service.getProjectHistory(project, null);
        Assert.assertTrue((String)"Refactoring history should be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        IFolder folder = this.fProject.getProject().getFolder(".refactorings");
        Assert.assertTrue((String)"Refactoring history folder should exist.", (boolean)folder.exists());
        this.setSharedRefactoringHistory(false);
        RefactoringHistory nextHistory = service.getProjectHistory(project, null);
        Assert.assertEquals((String)"Refactoring history should be the same:", (Object)previousHistory, (Object)nextHistory);
        Assert.assertFalse((String)"Refactoring history should not be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        Assert.assertFalse((String)"Refactoring history folder should not exist.", (boolean)folder.exists());
    }

    @Test
    public void testSharing1() throws Exception {
        IProject project = this.fProject.getProject();
        RefactoringHistoryService service = RefactoringHistoryService.getInstance();
        RefactoringHistory previousHistory = service.getProjectHistory(project, null);
        Assert.assertTrue((String)"Refactoring history should be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        IFolder folder = this.fProject.getProject().getFolder(".refactorings");
        Assert.assertTrue((String)"Refactoring history folder should exist.", (boolean)folder.exists());
        this.setSharedRefactoringHistory(false);
        RefactoringHistory nextHistory = service.getProjectHistory(project, null);
        Assert.assertEquals((String)"Refactoring history should be the same:", (Object)previousHistory, (Object)nextHistory);
        Assert.assertFalse((String)"Refactoring history should not be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        Assert.assertFalse((String)"Refactoring history folder should not exist.", (boolean)folder.exists());
        this.setSharedRefactoringHistory(true);
        RefactoringHistory lastHistory = service.getProjectHistory(project, null);
        Assert.assertEquals((String)"Refactoring history should be the same:", (Object)previousHistory, (Object)lastHistory);
        Assert.assertEquals((String)"Refactoring history should be the same:", (Object)nextHistory, (Object)lastHistory);
        Assert.assertTrue((String)"Refactoring history should be shared", (boolean)RefactoringHistoryService.hasSharedRefactoringHistory((IProject)project));
        Assert.assertTrue((String)"Refactoring history folder should exist.", (boolean)folder.exists());
    }

    @Test
    public void testSortOrder0() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)45L, (long)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    @Test
    public void testSortOrder1() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 10000000L, 50000000L, 0, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)5L, (long)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    @Test
    public void testSortOrder2() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 30000000L, 50000000L, 0, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)3L, (long)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    @Test
    public void testSortOrder3() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 110000000L, 140000000L, 1, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)4L, (long)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    @Test
    public void testSortOrder4() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 110000000L, 280000000L, 0, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)18L, (long)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    @Test
    public void testSortOrder5() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getProjectHistory(this.fProject.getProject(), 0L, Long.MAX_VALUE, 1024, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)5L, (long)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    @Test
    public void testSortOrder6() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(0L, Long.MAX_VALUE, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)45L, (long)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    @Test
    public void testSortOrder7() throws Exception {
        RefactoringHistory history = RefactoringHistoryService.getInstance().getWorkspaceHistory(30000000L, 50000000L, null);
        Assert.assertFalse((String)"Refactoring history must not be empty", (boolean)history.isEmpty());
        RefactoringDescriptorProxy[] proxies = history.getDescriptors();
        Assert.assertEquals((String)"Refactoring history has wrong size", (long)3L, (long)proxies.length);
        this.assertDescendingSortOrder(proxies);
    }

    private static final class RefactoringExecutionListener
    implements IRefactoringExecutionListener {
        private RefactoringExecutionEvent fLastEvent = null;

        private RefactoringExecutionListener() {
        }

        public void assertEventDescriptor(RefactoringDescriptorProxyAdapter expected) throws Exception {
            Assert.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            RefactoringDescriptor expectedDescriptor = expected.requestDescriptor(null);
            Assert.assertNotNull((String)"Could not resolve expected refactoring descriptor", (Object)expectedDescriptor);
            expectedDescriptor.setTimeStamp(this.fLastEvent.getDescriptor().getTimeStamp());
            Assert.assertEquals((String)"Wrong refactoring descriptor proxy in refactoring history event:", (Object)expected, (Object)this.fLastEvent.getDescriptor());
            RefactoringDescriptor actualDescriptor = this.fLastEvent.getDescriptor().requestDescriptor(null);
            Assert.assertNotNull((String)"Could not resolve actual refactoring descriptor", (Object)actualDescriptor);
            Assert.assertEquals((String)"Resolved refactoring descriptors are not equal:", (Object)expectedDescriptor, (Object)actualDescriptor);
        }

        public void assertEventSource(IRefactoringHistoryService expected) throws Exception {
            Assert.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            Assert.assertSame((String)"Wrong refactoring history service in refactoring history event:", (Object)expected, (Object)this.fLastEvent.getHistoryService());
        }

        public void assertEventType(int expected) throws Exception {
            Assert.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            Assert.assertEquals((String)"Wrong refactoring history event type:", (long)expected, (long)this.fLastEvent.getEventType());
        }

        public void connect() {
            this.fLastEvent = null;
            RefactoringHistoryService.getInstance().addExecutionListener((IRefactoringExecutionListener)this);
        }

        public void disconnect() {
            RefactoringHistoryService.getInstance().removeExecutionListener((IRefactoringExecutionListener)this);
            this.fLastEvent = null;
        }

        public void executionNotification(RefactoringExecutionEvent event) {
            int previous = this.fLastEvent != null ? this.fLastEvent.getEventType() : -1;
            switch (event.getEventType()) {
                case 1: {
                    Assert.assertEquals((String)"Previous event should be ABOUT_TO_PERFORM", (long)4L, (long)previous);
                    break;
                }
                case 3: {
                    Assert.assertEquals((String)"Previous event should be ABOUT_TO_REDO", (long)6L, (long)previous);
                    break;
                }
                case 2: {
                    Assert.assertEquals((String)"Previous event should be ABOUT_TO_UNDO", (long)5L, (long)previous);
                }
            }
            this.fLastEvent = event;
        }
    }

    private static final class RefactoringHistoryListener
    implements IRefactoringHistoryListener {
        private RefactoringHistoryEvent fLastEvent = null;

        private RefactoringHistoryListener() {
        }

        public void assertEventDescriptor(RefactoringDescriptorProxyAdapter expected) throws Exception {
            Assert.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            RefactoringDescriptor expectedDescriptor = expected.requestDescriptor(null);
            Assert.assertNotNull((String)"Could not resolve expected refactoring descriptor", (Object)expectedDescriptor);
            expectedDescriptor.setTimeStamp(this.fLastEvent.getDescriptor().getTimeStamp());
            Assert.assertEquals((String)"Wrong refactoring descriptor proxy in refactoring history event:", (Object)expected, (Object)this.fLastEvent.getDescriptor());
            RefactoringDescriptor actualDescriptor = this.fLastEvent.getDescriptor().requestDescriptor(null);
            Assert.assertNotNull((String)"Could not resolve actual refactoring descriptor", (Object)actualDescriptor);
            Assert.assertEquals((String)"Resolved refactoring descriptors are not equal:", (Object)expectedDescriptor, (Object)actualDescriptor);
        }

        public void assertEventSource(IRefactoringHistoryService expected) throws Exception {
            Assert.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            Assert.assertSame((String)"Wrong refactoring history service in refactoring history event:", (Object)expected, (Object)this.fLastEvent.getHistoryService());
        }

        public void assertEventType(int expected) throws Exception {
            Assert.assertNotNull((String)"No refactoring history event has been recorded", (Object)this.fLastEvent);
            Assert.assertEquals((String)"Wrong refactoring history event type:", (long)expected, (long)this.fLastEvent.getEventType());
        }

        public void connect() {
            this.fLastEvent = null;
            RefactoringHistoryService.getInstance().addHistoryListener((IRefactoringHistoryListener)this);
        }

        public void disconnect() {
            RefactoringHistoryService.getInstance().removeHistoryListener((IRefactoringHistoryListener)this);
            this.fLastEvent = null;
        }

        public void historyNotification(RefactoringHistoryEvent event) {
            this.fLastEvent = event;
        }
    }
}

