/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.participants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CancelingParticipantTests {
    private int fCancelStep;
    private ILogListener fLogListener;
    private List<IStatus> fLogEntries;

    @Before
    public void setUp() {
        this.fLogListener = (status, plugin) -> {
            boolean bl = this.fLogEntries.add(status);
        };
        Platform.addLogListener((ILogListener)this.fLogListener);
        this.fLogEntries = new ArrayList<IStatus>();
    }

    @After
    public void tearDown() throws Exception {
        Platform.removeLogListener((ILogListener)this.fLogListener);
    }

    @Test
    public void testCheckConditions() throws Exception {
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)new TestProcessor());
        this.fCancelStep = 0;
        PerformRefactoringOperation op = new PerformRefactoringOperation((Refactoring)refactoring, 6);
        NullProgressMonitor pm = new NullProgressMonitor();
        boolean exception = false;
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, (IProgressMonitor)pm);
        }
        catch (OperationCanceledException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)pm.isCanceled());
        Assert.assertEquals((Object)Collections.EMPTY_LIST.toString(), (Object)this.fLogEntries.toString());
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testCreateChange() throws Exception {
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)new TestProcessor());
        this.fCancelStep = 1;
        PerformRefactoringOperation op = new PerformRefactoringOperation((Refactoring)refactoring, 6);
        NullProgressMonitor pm = new NullProgressMonitor();
        boolean exception = false;
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, (IProgressMonitor)pm);
        }
        catch (OperationCanceledException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)pm.isCanceled());
        Assert.assertEquals((Object)Collections.EMPTY_LIST.toString(), (Object)this.fLogEntries.toString());
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testCreatePreChange() throws Exception {
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)new TestProcessor());
        this.fCancelStep = 2;
        PerformRefactoringOperation op = new PerformRefactoringOperation((Refactoring)refactoring, 6);
        NullProgressMonitor pm = new NullProgressMonitor();
        boolean exception = false;
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, (IProgressMonitor)pm);
        }
        catch (OperationCanceledException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)pm.isCanceled());
        Assert.assertEquals((Object)Collections.EMPTY_LIST.toString(), (Object)this.fLogEntries.toString());
        Assert.assertTrue((boolean)exception);
    }

    private class CancelingParticipant
    extends RenameParticipant {
        private CancelingParticipant() {
        }

        protected boolean initialize(Object element) {
            return true;
        }

        public String getName() {
            return "canceling participant";
        }

        public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
            if (CancelingParticipantTests.this.fCancelStep == 0) {
                pm.setCanceled(true);
                throw new OperationCanceledException();
            }
            return new RefactoringStatus();
        }

        public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            if (CancelingParticipantTests.this.fCancelStep == 1) {
                pm.setCanceled(true);
                throw new OperationCanceledException();
            }
            return new NullChange("1");
        }

        public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            if (CancelingParticipantTests.this.fCancelStep == 2) {
                pm.setCanceled(true);
                throw new OperationCanceledException();
            }
            return new NullChange("2");
        }
    }

    private class TestProcessor
    extends RenameProcessor {
        private Object fElement = Boolean.TRUE;

        private TestProcessor() {
        }

        public Object[] getElements() {
            return new Object[]{this.fElement};
        }

        public String getIdentifier() {
            return "org.eclipse.ltk.core.refactoring.tests.TestProcessor";
        }

        public String getProcessorName() {
            return "processor";
        }

        public boolean isApplicable() throws CoreException {
            return true;
        }

        public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new NullChange("test change");
        }

        public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
            CancelingParticipant participant = new CancelingParticipant();
            participant.initialize((RefactoringProcessor)this, this.fElement, (RefactoringArguments)new RenameArguments("", false));
            return new RefactoringParticipant[]{participant};
        }
    }
}

