/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests.participants;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.harness.FussyProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.tests.participants.ElementRenameProcessor;
import org.eclipse.ltk.core.refactoring.tests.participants.ElementRenameRefactoring;
import org.eclipse.ltk.core.refactoring.tests.participants.FailingParticipant;
import org.eclipse.ltk.core.refactoring.tests.participants.FailingParticipant2;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FailingParticipantTests {
    private ElementRenameRefactoring fRefactoring;
    private ILogListener fLogListener;
    private List<IStatus> fLogEntries;

    @Before
    public void setUp() {
        this.fLogListener = (status, plugin) -> {
            boolean bl = this.fLogEntries.add(status);
        };
        Platform.addLogListener((ILogListener)this.fLogListener);
    }

    @After
    public void tearDown() throws Exception {
        Platform.removeLogListener((ILogListener)this.fLogListener);
    }

    private void resetLog() {
        this.fLogEntries = new ArrayList<IStatus>();
    }

    @Test
    public void testFailingParticipants() throws Exception {
        this.fRefactoring = new ElementRenameRefactoring(0);
        FussyProgressMonitor pm = new FussyProgressMonitor();
        this.fRefactoring.checkInitialConditions((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        this.fRefactoring.checkFinalConditions((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        this.resetLog();
        boolean exception = false;
        try {
            this.fRefactoring.createChange((IProgressMonitor)pm);
        }
        catch (FailingParticipant.Exception e) {
            exception = true;
        }
        pm.assertUsedUp();
        pm.prepare();
        Assert.assertEquals((long)1L, (long)this.fLogEntries.size());
        IStatus status = this.fLogEntries.get(0);
        Assert.assertEquals((String)"Exception wrong", status.getException().getClass(), FailingParticipant.Exception.class);
        Assert.assertTrue((String)"No exception generated", (boolean)exception);
        this.resetLog();
        this.fRefactoring = new ElementRenameRefactoring(0);
        this.fRefactoring.checkInitialConditions((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        this.fRefactoring.checkFinalConditions((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        Change change = this.fRefactoring.createChange((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        exception = false;
        try {
            change.perform((IProgressMonitor)pm);
        }
        catch (FailingParticipant2.Exception e) {
            exception = true;
        }
        pm.assertUsedUp();
        pm.prepare();
        Assert.assertEquals((long)1L, (long)this.fLogEntries.size());
        status = this.fLogEntries.get(0);
        Assert.assertEquals((String)"Exception wrong", status.getException().getClass(), FailingParticipant2.Exception.class);
        Assert.assertTrue((String)"No exception generated", (boolean)exception);
        this.resetLog();
        this.fRefactoring = new ElementRenameRefactoring(0);
        this.fRefactoring.checkInitialConditions((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        this.fRefactoring.checkFinalConditions((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        change = this.fRefactoring.createChange((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        change.perform((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        Assert.assertEquals((long)0L, (long)this.fLogEntries.size());
        Assert.assertTrue((String)"Working participant not executed", (boolean)ElementRenameProcessor.fHistory.contains("workingExec"));
    }

    @Test
    public void testFailingRefactorWithPreParticipants() throws Exception {
        this.fRefactoring = new ElementRenameRefactoring(7);
        FussyProgressMonitor pm = new FussyProgressMonitor();
        this.fRefactoring.checkInitialConditions((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        this.fRefactoring.checkFinalConditions((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        this.resetLog();
        boolean exception = false;
        Change change = this.fRefactoring.createChange((IProgressMonitor)pm);
        pm.assertUsedUp();
        pm.prepare();
        try {
            change.perform((IProgressMonitor)pm);
            pm.assertUsedUp();
        }
        catch (RuntimeException e) {
            exception = true;
        }
        Assert.assertEquals((long)2L, (long)this.fLogEntries.size());
        IStatus status = this.fLogEntries.get(0);
        Assert.assertEquals((String)"Exception wrong", status.getException().getClass(), RuntimeException.class);
        Assert.assertEquals((String)"Status code wrong", (long)10008L, (long)status.getCode());
        status = this.fLogEntries.get(1);
        Assert.assertNull((String)"Exception wrong", (Object)status.getException());
        Assert.assertEquals((String)"Status code wrong", (long)10009L, (long)status.getCode());
        Assert.assertTrue((String)"No exception generated", (boolean)exception);
        Assert.assertTrue((String)"Working participant not created", (boolean)ElementRenameProcessor.fHistory.contains("workingCreate"));
        Assert.assertFalse((String)"Working participant executed", (boolean)ElementRenameProcessor.fHistory.contains("workingExec"));
        Assert.assertTrue((String)"Working participant pre not created pre", (boolean)ElementRenameProcessor.fHistory.contains("workingPreCreatePre"));
        Assert.assertTrue((String)"Working participant pre not created", (boolean)ElementRenameProcessor.fHistory.contains("workingPreCreate"));
        Assert.assertTrue((String)"Working participant pre not executed pre", (boolean)ElementRenameProcessor.fHistory.contains("workingPreExecPre"));
        Assert.assertFalse((String)"Working participant pre executed", (boolean)ElementRenameProcessor.fHistory.contains("workingPreExec"));
        this.fRefactoring = new ElementRenameRefactoring(5);
        this.fRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor());
        this.fRefactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
        this.resetLog();
        change = this.fRefactoring.createChange((IProgressMonitor)new NullProgressMonitor());
        change.perform((IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)0L, (long)this.fLogEntries.size());
        Assert.assertTrue((String)"Working participant not created", (boolean)ElementRenameProcessor.fHistory.contains("workingCreate"));
        Assert.assertTrue((String)"Working participant not executed", (boolean)ElementRenameProcessor.fHistory.contains("workingExec"));
        Assert.assertFalse((String)"Working participant pre created pre", (boolean)ElementRenameProcessor.fHistory.contains("workingPreCreatePre"));
        Assert.assertFalse((String)"Working participant pre created", (boolean)ElementRenameProcessor.fHistory.contains("workingPreCreate"));
        Assert.assertFalse((String)"Working participant pre executed", (boolean)ElementRenameProcessor.fHistory.contains("workingPreExec"));
        Assert.assertFalse((String)"Working participant pre executed pre", (boolean)ElementRenameProcessor.fHistory.contains("workingPreExecPre"));
    }
}

